# Practitioner (EU base) - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner (EU base)**

## Resource Profile: Practitioner (EU base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu | *Version*:0.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PractitionerEu |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context. 

**Usages:**

* Derived from this Profile: [Practitioner (EU core)](StructureDefinition-practitioner-eu-core.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/practitioner-eu)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitioner-eu.csv), [Excel](StructureDefinition-practitioner-eu.xlsx), [Schematron](StructureDefinition-practitioner-eu.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitioner-eu",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu",
  "version" : "0.1.0",
  "name" : "PractitionerEu",
  "title" : "Practitioner (EU base)",
  "status" : "active",
  "date" : "2025-10-26T22:29:28+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "constraint" : [
          {
            "key" : "name-or-identifier",
            "severity" : "error",
            "human" : "identifier or name SHALL be present",
            "expression" : "identifier.exists() or name.exists()",
            "source" : "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu"
          }
        ]
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "short" : "Practitioner identifier"
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "Practitioner Name"
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "short" : "Contact details for the practitioner"
      },
      {
        "id" : "Practitioner.address",
        "path" : "Practitioner.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu"]
          }
        ]
      }
    ]
  }
}

```
