# Home - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5 | *Version*:0.1.0 |
| Active as of 2025-10-26 | *Computable Name*:Hl7EuBaseIg |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

This Implementation Guide (IG) brings together **base** and **core** HL7® FHIR® artifacts designed specifically for the European context.

It provides a foundation for interoperability, ensuring reusability across national projects, European initiatives, and derived HL7 Europe guides.

The guide supports:

* Developers and implementers who need common building blocks.
* Policymakers and program leads who require consistent definitions for EHDS-aligned projects.
* Standards experts who wish to build on a harmonized European foundation.

### Introduction

The HL7 Europe Base and Core Implementation Guide provides a **layered approach to FHIR interoperability** in the European context; and it aims to support a coherent and reusable set of FHIR specifications across Europe.

It includes:

* **Base profiles.** Loosely constrained baseline definitions of common European concepts (e.g., Patient, Practitioner). They provide flexibility and serve as the foundation for Core and derived profiles.
* **Core profiles.** More constrained profiles designed for reuse across most European IGs. They introduce essential constraints, can often be used directly, and pursue alignment with IPS.

See the [**Introduction**page](introduction.md) for detailed explanations of Base and Core profiles, their relationship with Extensions and scoped IGs, and their alignment with EHDS and IPS.

**Fig. 1 - European Base and Core profiles**

### Guide Publication

This guide is published for two HL7 FHIR versions:

* **HL7 FHIR R4 Base IG** (hl7.fhir.eu.base). Published at [this link](https://hl7.eu/fhir/base).
* **HL7 FHIR R5 Base IG** (hl7.fhir.eu.base-r5). This Guide.

Both versions are maintained by HL7 Europe and evolve based on community feedback and EHDS requirements.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.eu.base-r5",
  "url" : "http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5",
  "version" : "0.1.0",
  "name" : "Hl7EuBaseIg",
  "title" : "HL7 Europe Base and Core FHIR IG",
  "status" : "active",
  "date" : "2025-10-26T22:29:28+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This guide collects base and core profiles to be used in the European context. It also includes common artifacts, such as the profiles describing the European Health Insurance Card.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "packageId" : "hl7.fhir.eu.base-r5",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_eu_extensions_r5",
      "uri" : "http://hl7.eu/fhir/extensions",
      "packageId" : "hl7.fhir.eu.extensions.r5",
      "version" : "0.1.1"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.8.0"
      }
    ],
    "grouping" : [
      {
        "id" : "EuBaseProfiles",
        "name" : "HL7 Europe Base Profiles",
        "description" : "Base profiles for the European context."
      },
      {
        "id" : "EuCoreProfiles",
        "name" : "HL7 Europe Core Profiles",
        "description" : "Core profiles for the European context."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Address-eu"
        },
        "name" : "Address (EU)",
        "description" : "This profile extends the Address data type for supporting streetname, housenumber and postal box.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Patient-animal-example"
        },
        "name" : "Animal Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient Animal (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-animal-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteLaterality-eu"
        },
        "name" : "Body Structure Laterality",
        "description" : "Body Structure site laterality qualifier. It indicates - for example - the body site laterality from which a laboratory specimen is collected. (based on SNOMED CT)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteQualifier-eu"
        },
        "name" : "Body Structure Qualifier",
        "description" : "Body Structure site qualifier. It indicates - for example - the body site qualifier from which a laboratory specimen is collected. (based on SNOMED CT)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bodyStructure-eu-core"
        },
        "name" : "BodyStructure (EU core)",
        "description" : "This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BodyStructure"
          }
        ],
        "reference" : {
          "reference" : "BodyStructure/example-body-structure-eu"
        },
        "name" : "BodyStructure Example",
        "description" : "Example of a BodyStructure resource conforming to the BodyStructure (EU) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/bodyStructure-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/location-eu-core"
        },
        "name" : "Location (EU core)",
        "description" : "This profile sets minimum expectations for the Location resource to be used for the purpose of this guide.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-location"
        },
        "name" : "Location Example",
        "description" : "Example of a Location resource conforming to the Location (EU) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/location-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu"
        },
        "name" : "Organization (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu-core"
        },
        "name" : "Organization (EU core)",
        "description" : "This profile sets minimum expectations for the Organization resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/organization-eu-core-example"
        },
        "name" : "Organization Example",
        "description" : "Example of an Organization resource conforming to the Organization (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu"
        },
        "name" : "Patient (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu-core"
        },
        "name" : "Patient (EU core)",
        "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases.\nWhen the ips-pat-1 invariant is satisfied \\(Patient.name.given, Patient.name.family or Patient.name.text SHALL be present\\) then this profile complies with the IPS patient profile.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient-eu-core-example"
        },
        "name" : "Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient (EU Core) profile.",
        "isExample" : true,
        "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-animal-eu-core"
        },
        "name" : "Patient: Animal (EU core)",
        "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu"
        },
        "name" : "Practitioner (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu-core"
        },
        "name" : "Practitioner (EU core)",
        "description" : "This profile sets minimum expectations for the Practitioner resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner-eu-core-example"
        },
        "name" : "Practitioner Example",
        "description" : "Example of a Practitioner resource conforming to the Practitioner (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu"
        },
        "name" : "PractitionerRole (EU base)",
        "description" : "This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu-core"
        },
        "name" : "PractitionerRole (EU core)",
        "description" : "This profile sets minimum expectations for the PractitionerRole resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/practitionerRole-eu-core-example"
        },
        "name" : "PractitionerRole Example",
        "description" : "Example of a PractitionerRole resource conforming to the PractitionerRole (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/speciesType-eu"
        },
        "name" : "Types of species",
        "description" : "Animal species types for non-human subjects",
        "isExample" : false
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "authors.html",
          "name" : "authors.html",
          "title" : "Authors and Contributors",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "copyright.html",
          "name" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "crossversionanalysis.html",
          "name" : "crossversionanalysis.html",
          "title" : "Cross-version Analysis",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "dependencies.html",
          "name" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "knownissues.html",
          "name" : "knownissues.html",
          "title" : "Known Issues",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "introduction.html",
          "name" : "introduction.html",
          "title" : "Introduction",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "modelmap.html",
          "name" : "modelmap.html",
          "title" : "Model Map",
          "generation" : "html"
        },
        {
          "sourceUrl" : "logicalmodels.html",
          "name" : "logicalmodels.html",
          "title" : "Logical Models",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "missing-data.html",
          "name" : "missing-data.html",
          "title" : "Handling Missing Data",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2024+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "trial-use"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "http://terminology.hl7.eu/CodeSystem/v3-ActCode"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "show-inherited-invariants"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "usage-stats-opt-out"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://hl7.eu/fhir/base-r5/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
