# Organization (EU base) - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization (EU base)**

## Resource Profile: Organization (EU base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu | *Version*:0.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:OrganizationEu |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context. 

**Usages:**

* Derived from this Profile: [Organization (EU core)](StructureDefinition-organization-eu-core.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/organization-eu)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization-eu.csv), [Excel](StructureDefinition-organization-eu.xlsx), [Schematron](StructureDefinition-organization-eu.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization-eu",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu",
  "version" : "0.1.0",
  "name" : "OrganizationEu",
  "title" : "Organization (EU base)",
  "status" : "active",
  "date" : "2025-10-26T22:29:28+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "constraint" : [
          {
            "key" : "name-or-identifier",
            "severity" : "error",
            "human" : "identifier or name SHALL be present",
            "expression" : "identifier.exists() or name.exists()",
            "source" : "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu"
          }
        ]
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "Organization business identifier"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "Organization type"
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "Name of the organization"
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "short" : "Organization contact infos"
      },
      {
        "id" : "Organization.contact.telecom",
        "path" : "Organization.contact.telecom",
        "short" : "Organization telecom"
      },
      {
        "id" : "Organization.contact.address",
        "path" : "Organization.contact.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu"]
          }
        ]
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "short" : "The organization of which this organization is part of: e.g. an ERN"
      }
    ]
  }
}

```
