# AllergyIntolerance Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance Example**

## Example AllergyIntolerance: AllergyIntolerance Example

Profile: [Allergy Intolerance (EU core)](StructureDefinition-allergyIntolerance-eu-core.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**category**: Food

**criticality**: Low Risk

**code**: Allergy to peanuts

**patient**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**onset**: 2012-05-01

> **reaction**

### Manifestations

| | |
| :--- | :--- |
| - | **Concept** |
| * | Eruption of skin |

**severity**: Mild



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "allergyintolerance-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/allergyIntolerance-eu-core"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "type" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/allergy-intolerance-type",
        "code" : "allergy"
      }
    ]
  },
  "category" : ["food"],
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91935009",
        "display" : "Allergy to peanuts"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "onsetDateTime" : "2012-05-01",
  "reaction" : [
    {
      "manifestation" : [
        {
          "concept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "271807003",
                "display" : "Eruption of skin"
              }
            ]
          }
        }
      ],
      "severity" : "mild"
    }
  ]
}

```
