# Composition Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition Example**

## Example Composition: Composition Example

Profile: [Composition (EU core)](StructureDefinition-composition-eu-core.md)

**Composition: Information recipient**: [Nuovo Ospedale S.Agostino (MO)](Organization-organization-eu-core-example.md)

**Document DiagnosticReport Reference**: [Diagnostic Report for 'Laboratory report' for '->John Doe Male, DoB: 1980-01-01'](DiagnosticReport-5679723c-4fae-4ba7-9f09-5438a827bfda.md)

**identifier**: `http://example.org/composition-ids`/c030702.TSTSMN63A01F205H.20220325112426.TSS1Tkju

**status**: Final

**type**: Laboratorní zpráva

**category**: Chemistry studies (set)

**date**: 2022-03-30 11:24:26+0100

**author**: [PractitionerRole General practice (specialty)](PractitionerRole-practitionerRole-eu-core-example.md)

**title**: Laboratorní zpráva

### Attesters

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Mode** | **Time** | **Party** |
| * | Legal | 2022-03-25 11:00:00+0100 | [PractitionerRole General practice (specialty)](PractitionerRole-practitionerRole-eu-core-example.md) |

**custodian**: Example Health Organization



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "26032a57-083a-4ddf-b019-e566ae02f740",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/composition-eu-core"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.eu/fhir/StructureDefinition/information-recipient",
      "valueReference" : {
        "reference" : "Organization/organization-eu-core-example",
        "display" : "Nuovo Ospedale S.Agostino (MO)"
      }
    },
    {
      "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/composition-diagnosticReportReference",
      "valueReference" : {
        "reference" : "DiagnosticReport/5679723c-4fae-4ba7-9f09-5438a827bfda"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://example.org/composition-ids",
      "value" : "c030702.TSTSMN63A01F205H.20220325112426.TSS1Tkju"
    }
  ],
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11502-2",
        "display" : "Laboratory report"
      }
    ],
    "text" : "Laboratorní zpráva"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "18719-5",
          "display" : "Chemistry studies (set)"
        }
      ]
    }
  ],
  "subject" : [
    {
      "reference" : "Patient/patient-eu-core-example"
    }
  ],
  "date" : "2022-03-30T11:24:26+01:00",
  "author" : [
    {
      "reference" : "PractitionerRole/practitionerRole-eu-core-example"
    }
  ],
  "title" : "Laboratorní zpráva",
  "attester" : [
    {
      "mode" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/composition-attestation-mode",
            "code" : "legal"
          }
        ]
      },
      "time" : "2022-03-25T11:00:00+01:00",
      "party" : {
        "reference" : "PractitionerRole/practitionerRole-eu-core-example"
      }
    }
  ],
  "custodian" : {
    "display" : "Example Health Organization"
  },
  "section" : [
    {
      "title" : "Urine examinations",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "18729-4",
            "display" : "Urinalysis studies (set)"
          }
        ],
        "text" : "ESAMI DELLE URINE"
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table id=\"nota1\"><thead><tr><th>Date</th><th>Test</th><th>Value</th><th>Unit(s)</th><th>Reference Range</th><th>Interpretation</th></tr></thead><tbody><tr><td>2023-03-27</td><td>Urea (U) [Moles/Vol]</td><td>310</td><td>mmol/L</td><td>67 - 580 mmol/L</td><td>Significantly low</td></tr></tbody></table></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/763f7902-8103-4d10-8bd1-546a726d43ee"
        }
      ]
    }
  ]
}

```
