# Condition Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Example**

## Example Condition: Condition Example

Profile: [Condition (EU core)](StructureDefinition-condition-eu-core.md)

**Condition Asserted Date**: 2024-12-01

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item

**severity**: Severe

**code**: Pneumonia

**bodySite**: Lower lobe of left lung

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**onset**: 2024-11-30

**recordedDate**: 2024-12-02

### Participants

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole General practice (specialty)](PractitionerRole-practitionerRole-eu-core-example.md) |

**note**: 

> 

Productive cough with fever; antibiotics started during admission.




## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/condition-eu-core"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2024-12-01"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "24484000",
        "display" : "Severe"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "233604007",
        "display" : "Pneumonia"
      }
    ]
  },
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "41224006",
          "display" : "Lower lobe of left lung"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "onsetDateTime" : "2024-11-30",
  "recordedDate" : "2024-12-02",
  "participant" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/practitionerRole-eu-core-example"
      }
    }
  ],
  "note" : [
    {
      "text" : "Productive cough with fever; antibiotics started during admission."
    }
  ]
}

```
