# MedicationRequest Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Example**

## Example MedicationRequest: MedicationRequest Example

Profile: [MedicationRequest (EU core)](StructureDefinition-medicationRequest-eu-core.md)

Tag: Actionable (Details: Common Tags code actionable = 'Actionable')

**identifier**: 10-123EP

**status**: Active

**intent**: Order

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = cefuroxime; doseForm = Powder for solution for injection or infusion](Medication-01A-Cefuroxime1500GenericExplicit.md) |

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**authoredOn**: 2024-12-06

**requester**: The Best Doctor

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Bronchopneumonia caused by bacteria (disorder) |

> **dosageInstruction****sequence**: 1**timing**: Once per 8 hours**route**:Intramuscular route

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1500 milligram(s)(Details: UCUM codemg = 'mg') |


> **dosageInstruction****sequence**: 2**timing**: Once per 8 hours**route**:Intramuscular route

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 750-1500 milligram(s) |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "400C-prescription-cefuroxime-singleline",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/medicationRequest-eu-core"
    ],
    "tag" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/common-tags",
        "code" : "actionable"
      }
    ]
  },
  "identifier" : [
    {
      "value" : "10-123EP"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medication" : {
    "reference" : {
      "reference" : "Medication/01A-Cefuroxime1500GenericExplicit"
    }
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "authoredOn" : "2024-12-06",
  "requester" : {
    "display" : "The Best Doctor"
  },
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "10625071000119104",
            "display" : "Bronchopneumonia caused by bacteria (disorder)"
          }
        ]
      }
    }
  ],
  "dosageInstruction" : [
    {
      "sequence" : 1,
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 3,
            "unit" : "day",
            "system" : "http://unitsofmeasure.org",
            "code" : "d"
          },
          "frequency" : 1,
          "period" : 8,
          "periodUnit" : "h"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "78421000",
            "display" : "Intramuscular route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1500,
            "unit" : "milligram(s)",
            "system" : "http://unitsofmeasure.org",
            "code" : "mg"
          }
        }
      ]
    },
    {
      "sequence" : 2,
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 4,
            "unit" : "day",
            "system" : "http://unitsofmeasure.org",
            "code" : "d"
          },
          "frequency" : 1,
          "period" : 8,
          "periodUnit" : "h"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "78421000",
            "display" : "Intramuscular route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseRange" : {
            "low" : {
              "value" : 750,
              "unit" : "milligram(s)",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg"
            },
            "high" : {
              "value" : 1500,
              "unit" : "milligram(s)",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg"
            }
          }
        }
      ]
    }
  ]
}

```
