# Organization Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Example**

## Example Organization: Organization Example

Profile: [Organization (EU core)](StructureDefinition-organization-eu-core.md)

**type**: Healthcare Provider

**name**: Example Health Organization

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 555-1234(Work) | 123 Example Street Example City EX 12345 EX |



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "organization-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu-core"
    ]
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "Example Health Organization",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "555-1234",
          "use" : "work"
        }
      ],
      "address" : {
        "line" : ["123 Example Street"],
        "city" : "Example City",
        "state" : "EX",
        "postalCode" : "12345",
        "country" : "EX"
      }
    }
  ]
}

```
