# Address (EU) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address (EU)**

## Data Type Profile: Address (EU) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:AddressEu |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile extends the Address data type for supporting streetname, housenumber and postal box. 

### Address extensions

The Address extensions provide additional information about a patient's address, as the fact that it is an official address, or more structured information about the address itself.

This profile doesn't explicitly list all of them, but only those that are **explicitly listed in the[EHDS Address model](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAddress.html)**.

Examples of extensions not included, but used in several jurisdictions are:

* [ADXPBuildingNumberSuffix](http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-buildingNumberSuffix)
* [ADXPAdditionalLocator](http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator)
* [ADXPUnitID](http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitID)

Implementers should refer to the HL7 FHIR specification for guidance on the use of these extensions.

Please note that the fact they are not included in the differential doesn't preclude their use in a compliant instance.

**Usages:**

* Use this DataType Profile: [Location (EU core)](StructureDefinition-location-eu-core.md), [Organization (EU base)](StructureDefinition-organization-eu.md), [Patient (EU base)](StructureDefinition-patient-eu.md) and [Practitioner (EU base)](StructureDefinition-practitioner-eu.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/Address-eu)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Address-eu.csv), [Excel](StructureDefinition-Address-eu.xlsx), [Schematron](StructureDefinition-Address-eu.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Address-eu",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu",
  "version" : "2.0.0-ballot",
  "name" : "AddressEu",
  "title" : "Address (EU)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile extends the Address data type for supporting streetname, housenumber and postal box.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Address",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address"
      },
      {
        "id" : "Address.use",
        "path" : "Address.use",
        "short" : "Purpose of this address"
      },
      {
        "id" : "Address.type",
        "path" : "Address.type",
        "short" : "Address type (postal | physical)"
      },
      {
        "id" : "Address.line",
        "path" : "Address.line",
        "comment" : "When extensions are used for providing structured information the line element SHOULD be populated with a human readable representation of the line."
      },
      {
        "id" : "Address.line.extension",
        "path" : "Address.line.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Address.line.extension:streetName",
        "path" : "Address.line.extension",
        "sliceName" : "streetName",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName"
            ]
          }
        ]
      },
      {
        "id" : "Address.line.extension:houseNumber",
        "path" : "Address.line.extension",
        "sliceName" : "houseNumber",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber"
            ]
          }
        ]
      },
      {
        "id" : "Address.line.extension:postBox",
        "path" : "Address.line.extension",
        "sliceName" : "postBox",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox"
            ]
          }
        ]
      },
      {
        "id" : "Address.city",
        "path" : "Address.city",
        "short" : "City"
      },
      {
        "id" : "Address.postalCode",
        "path" : "Address.postalCode",
        "short" : "Postal code"
      },
      {
        "id" : "Address.country.extension",
        "path" : "Address.country.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Address.country.extension:countryCode",
        "path" : "Address.country.extension",
        "sliceName" : "countryCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-codedString"
            ]
          }
        ]
      },
      {
        "id" : "Address.country.extension:countryCode.value[x]",
        "path" : "Address.country.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      }
    ]
  }
}

```
