# DiagnosticReport (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DiagnosticReport (EU core)**

## Resource Profile: DiagnosticReport (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/diagnosticReport-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:DiagnosticReportEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the DiagnosticReport resource for commonly used EHDS documents. 

**Usages:**

* Examples for this Profile: [DiagnosticReport/5679723c-4fae-4ba7-9f09-5438a827bfda](DiagnosticReport-5679723c-4fae-4ba7-9f09-5438a827bfda.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/diagnosticReport-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-diagnosticReport-eu-core.csv), [Excel](StructureDefinition-diagnosticReport-eu-core.xlsx), [Schematron](StructureDefinition-diagnosticReport-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "diagnosticReport-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/diagnosticReport-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "DiagnosticReportEuCore",
  "title" : "DiagnosticReport (EU core)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the DiagnosticReport resource for commonly used EHDS documents.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "Diagnostic Report EU core",
        "definition" : "Diagnostic Report EU core"
      },
      {
        "id" : "DiagnosticReport.extension",
        "path" : "DiagnosticReport.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.extension:DiagnosticReportCompositionR5",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "DiagnosticReportCompositionR5",
        "short" : "Associated  Composition",
        "definition" : "This extension implements the R5 composition element. It allow to link this DiagnosticReport with the Composition documenting this Diagnostic Report.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.composition"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:DiagnosticReportCompositionR5.value[x]",
        "path" : "DiagnosticReport.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/composition-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:note",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "note",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.note"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:note.value[x].extension:annotation-type",
        "path" : "DiagnosticReport.extension.value[x].extension",
        "sliceName" : "annotation-type",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/annotationType"]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:note.value[x].extension:annotation-type.value[x]",
        "path" : "DiagnosticReport.extension.value[x].extension.value[x]",
        "short" : "Type of note"
      },
      {
        "id" : "DiagnosticReport.identifier",
        "path" : "DiagnosticReport.identifier",
        "comment" : "Usually assigned by the Information System of the diagnostic service provider for facilitating the Report search. The order id can be used as one of the Report identifier if only one report is produced for that order."
      },
      {
        "id" : "DiagnosticReport.basedOn",
        "path" : "DiagnosticReport.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/ServiceRequest"]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "short" : "Status of the Report",
        "comment" : "DiagnosticReport.status and Composition.status shall be aligned"
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.category:diagnostic-service",
        "path" : "DiagnosticReport.category",
        "sliceName" : "diagnostic-service",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "short" : "Type of Diagnostic Report",
        "definition" : "Defines the document type, it is recommended to take this from the suggested LOINC set."
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "short" : "Who and/or what this report is about",
        "definition" : "Who or what this report is about. The report can be about a human patient, a living subject, a device (e.g. a machine), a location or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-animal-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Location",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "short" : "The healthcare event which this Diagnostic Report is about (when test ordered).",
        "definition" : "The healthcare event (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.",
        "comment" : "This will typically be the encounter the event occurred within, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission laboratory tests)."
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "Clinically relevant time/time-period for report."
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "description" : "Organization that delivered the report",
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Responsible Diagnostic Service.",
        "comment" : "If a DiagnosticReport.resultsInterpreter exists this is expected to be a Composition.author; otherwise a DiagnosticReport.performer should be an author."
      },
      {
        "id" : "DiagnosticReport.performer:organization",
        "path" : "DiagnosticReport.performer",
        "sliceName" : "organization",
        "short" : "The organization producer of this report",
        "definition" : "The organization responsible for producing this report. In case practitioners produce them in their private practices, they will be accounted as an organization for this purpose.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter",
        "path" : "DiagnosticReport.resultsInterpreter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "description" : "Primary interpreter of results",
          "ordered" : false,
          "rules" : "open"
        },
        "comment" : "If a DiagnosticReport.resultsInterpreter exists this is expected to be a Composition.author; otherwise a DiagnosticReport.performer should be an author."
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter:author",
        "path" : "DiagnosticReport.resultsInterpreter",
        "sliceName" : "author",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen",
        "path" : "DiagnosticReport.specimen",
        "short" : "Specimens this report is based on."
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "short" : "results"
      },
      {
        "id" : "DiagnosticReport.study",
        "path" : "DiagnosticReport.study",
        "short" : "Study subject to this report"
      },
      {
        "id" : "DiagnosticReport.media",
        "path" : "DiagnosticReport.media",
        "short" : "Additional data (like images, diagrams or documents) associated with this report",
        "definition" : "A list of additional data, other then presented form of the report, associated with this report. This data is generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).",
        "requirements" : "Some diagnostic reports may include additional data such as images, diagrams or documents that are relevant to the report. This additional information can provide further context and support for the findings presented in the report.",
        "alias" : [
          "DICOM; Slides; Scans; Pictures; Documents; Diagrams",
          "Slides",
          "Scans"
        ]
      },
      {
        "id" : "DiagnosticReport.media.comment",
        "path" : "DiagnosticReport.media.comment",
        "definition" : "Allows for a comment about the image or data, such as an explanation of its significance or context within the diagnostic report.",
        "requirements" : "The provider of the report should make a comment about each image or data included in the report. This comment can provide valuable context and help the reader understand the significance of the image or data in relation to the overall findings of the report."
      },
      {
        "id" : "DiagnosticReport.media.link",
        "path" : "DiagnosticReport.media.link",
        "short" : "Reference to the image or data",
        "definition" : "A reference to the image or data associated with this report."
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "path" : "DiagnosticReport.presentedForm",
        "short" : "Entire report as issued (pdf recommended)"
      }
    ]
  }
}

```
