# Immunization (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization (EU core)**

## Resource Profile: Immunization (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/immunization-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ImmunizationEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Immunization resource common to most of the use cases. 

 
This profile constrains the Immunization resource for the purpose of this guide. 

**Usages:**

* Examples for this Profile: [Immunization/immunization-eu-core-example](Immunization-immunization-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/immunization-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-immunization-eu-core.csv), [Excel](StructureDefinition-immunization-eu-core.xlsx), [Schematron](StructureDefinition-immunization-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "immunization-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/immunization-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "ImmunizationEuCore",
  "title" : "Immunization (EU core)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Immunization resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Immunization resource for the purpose of this guide.",
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization"
      },
      {
        "id" : "Immunization.status",
        "path" : "Immunization.status",
        "short" : "Immunization status."
      },
      {
        "id" : "Immunization.statusReason",
        "path" : "Immunization.statusReason",
        "short" : "Reason for not performing."
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-uv-ips",
          "additional" : [
            {
              "purpose" : "candidate",
              "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSIVaccine",
              "documentation" : "Additional conformance binding to the cross-border vaccines value set."
            }
          ]
        }
      },
      {
        "id" : "Immunization.manufacturer",
        "path" : "Immunization.manufacturer",
        "short" : "Vaccine manufacturer/MAH"
      },
      {
        "id" : "Immunization.lotNumber",
        "path" : "Immunization.lotNumber",
        "short" : "Batch/lot number"
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Date of vaccination"
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime",
        "path" : "Immunization.occurrence[x]",
        "sliceName" : "occurrenceDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension",
        "path" : "Immunization.occurrence[x].extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension:periodOfLife",
        "path" : "Immunization.occurrence[x].extension",
        "sliceName" : "periodOfLife",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension:periodOfLife.value[x]",
        "path" : "Immunization.occurrence[x].extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base-r5/ValueSet/periodsOfLife-eu"
        }
      },
      {
        "id" : "Immunization.location",
        "path" : "Immunization.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/location-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.performer",
        "path" : "Immunization.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.function"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp",
        "path" : "Immunization.performer",
        "sliceName" : "administeringCentreOrHp",
        "short" : "Administering centre",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp.function",
        "path" : "Immunization.performer.function",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
              "code" : "AP"
            }
          ]
        }
      },
      {
        "id" : "Immunization.performer:administeringCentreOrHp.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu-core",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.reason.concept",
        "path" : "Immunization.reason.concept",
        "short" : "Reasons for the administration."
      },
      {
        "id" : "Immunization.protocolApplied.targetDisease",
        "path" : "Immunization.protocolApplied.targetDisease",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/target-diseases-uv-ips",
          "additional" : [
            {
              "purpose" : "candidate",
              "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSIIllnessandDisorder",
              "documentation" : "Additional conformance binding to a diseases value set for use in specific jurisdictional or for cross-border settings."
            }
          ]
        }
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber",
        "path" : "Immunization.protocolApplied.doseNumber",
        "short" : "Dose Number"
      },
      {
        "id" : "Immunization.protocolApplied.seriesDoses",
        "path" : "Immunization.protocolApplied.seriesDoses",
        "short" : "Number of doses"
      }
    ]
  }
}

```
