# MedicalTestResult (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicalTestResult (EU core)**

## Resource Profile: MedicalTestResult (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MedicalTestResultEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Observation resource for Medical Test Results common to most of the use cases. 

**Usages:**

* Refer to this Profile: [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md)
* Examples for this Profile: [Observation/763f7902-8103-4d10-8bd1-546a726d43ee](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/medicalTestResult-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medicalTestResult-eu-core.csv), [Excel](StructureDefinition-medicalTestResult-eu-core.xlsx), [Schematron](StructureDefinition-medicalTestResult-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medicalTestResult-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "MedicalTestResultEuCore",
  "title" : "MedicalTestResult (EU core)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Observation resource for Medical Test Results common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.identifier",
        "path" : "Observation.identifier",
        "requirements" : "EHDSObservation.header.identifier"
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "requirements" : "EHDSObservation.order"
      },
      {
        "id" : "Observation.triggeredBy.observation",
        "path" : "Observation.triggeredBy.observation",
        "requirements" : "EHDSObservation.triggeredBy[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "requirements" : "EHDSObservation.header.status"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "requirements" : "EHDSObservation has no requirement",
        "min" : 1
      },
      {
        "id" : "Observation.category:laboratory",
        "path" : "Observation.category",
        "sliceName" : "laboratory",
        "min" : 0,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "laboratory"
            }
          ]
        }
      },
      {
        "id" : "Observation.category:vital-signs",
        "path" : "Observation.category",
        "sliceName" : "vital-signs",
        "min" : 0,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "requirements" : "EHDSObservation.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base-r5/ValueSet/lab-obsCode-eu-lab"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "requirements" : "EHDSObservation.header.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "requirements" : "EHDSObservation.directSubject[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/location-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "requirements" : "EHDSObservation.observationDate[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.issued",
        "path" : "Observation.issued",
        "requirements" : "EHDSObservation.header.authorship.datetime"
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "requirements" : "EHDSObservation.header.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "requirements" : "EHDSObservation.result.value[x]"
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.extension:uncertainty",
        "path" : "Observation.value[x].extension",
        "sliceName" : "uncertainty",
        "requirements" : "EHDSObservation.result.uncertainty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty"
            ]
          }
        ]
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "requirements" : "EHDSObservation.dataAbsentReason"
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "requirements" : "EHDSObservation.interpretation"
      },
      {
        "id" : "Observation.note",
        "path" : "Observation.note",
        "requirements" : "EHDSObservation.resultDescription"
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "requirements" : "EHDSObservation.anatomicLocation"
      },
      {
        "id" : "Observation.bodyStructure",
        "path" : "Observation.bodyStructure",
        "requirements" : "EHDSObservation.anatomicLocation"
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "requirements" : "EHDSObservation.method"
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "requirements" : "Device information for laboratory observations"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "requirements" : "EHDSObservation.referenceRange"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "requirements" : "EHDSObservation.hasMember[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "requirements" : "EHDSObservation.derivedFrom[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core",
              "http://hl7.org/fhir/StructureDefinition/ImagingStudy"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "requirements" : "EHDSObservation.component"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "requirements" : "EHDSObservation.component.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base-r5/ValueSet/lab-obsCode-eu-lab"
        }
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "requirements" : "EHDSObservation.component.result.value[x]"
      },
      {
        "id" : "Observation.component.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component.value[x]:valueQuantity.extension:uncertainty",
        "path" : "Observation.component.value[x].extension",
        "sliceName" : "uncertainty",
        "requirements" : "EHDSObservation.component.result.uncertainty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "requirements" : "EHDSObservation.component.dataAbsentReason"
      },
      {
        "id" : "Observation.component.interpretation",
        "path" : "Observation.component.interpretation",
        "requirements" : "EHDSObservation.component.interpretation"
      },
      {
        "id" : "Observation.component.referenceRange",
        "path" : "Observation.component.referenceRange",
        "requirements" : "EHDSObservation.component.referenceRange"
      }
    ]
  }
}

```
