# Medication (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication (EU core)**

## Resource Profile: Medication (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/medication-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MedicationEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Medication resource common to most of the use cases. This profile is adapted from the MPD work. 

**Usages:**

* Refer to this Profile: [Medication (EU core)](StructureDefinition-medication-eu-core.md), [MedicationRequest (EU core)](StructureDefinition-medicationRequest-eu-core.md), [MedicationStatement (EU core)](StructureDefinition-medicationStatement-eu-core.md) and [Procedure (EU core)](StructureDefinition-procedure-eu-core.md)
* Examples for this Profile: [Medication/01A-Cefuroxime1500GenericExplicit](Medication-01A-Cefuroxime1500GenericExplicit.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/medication-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication-eu-core.csv), [Excel](StructureDefinition-medication-eu-core.xlsx), [Schematron](StructureDefinition-medication-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/medication-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "MedicationEuCore",
  "title" : "Medication (EU core)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Medication resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.extension:productName",
        "path" : "Medication.extension",
        "sliceName" : "productName",
        "short" : "Name of the medicinal product. Names of different types (full name, short name, etc) and in different languages can be provided if relevant.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-productname"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:classification",
        "path" : "Medication.extension",
        "sliceName" : "classification",
        "short" : "Classifications of the product, e.g ATC, narcotic/psychotropic, orphan drug, etc",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-classification"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:sizeOfItem",
        "path" : "Medication.extension",
        "sliceName" : "sizeOfItem",
        "short" : "Size of one item (for example, in a pack of 5 vials, this would represent the size of 1 vial)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-sizeofitem"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:characteristic",
        "path" : "Medication.extension",
        "sliceName" : "characteristic",
        "short" : "Specifies other descriptive properties of the medication.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-characteristic"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:unitOfPresentation",
        "path" : "Medication.extension",
        "sliceName" : "unitOfPresentation",
        "short" : "Unit of presentation of the product (e.g. tablet, vial, ampoule, etc)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-unitofpresentation"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:packageType",
        "path" : "Medication.extension",
        "sliceName" : "packageType",
        "short" : "Type of container. This information is more relevant in cases when the packaging has an impact on administration of the product (e.g. pre-filled syringe)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/medication-package-type"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:device",
        "path" : "Medication.extension",
        "sliceName" : "device",
        "short" : "Device, typically an administration device, included in the product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-device"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:device.extension:device",
        "path" : "Medication.extension.extension",
        "sliceName" : "device"
      },
      {
        "id" : "Medication.extension:device.extension:device.value[x]",
        "path" : "Medication.extension.extension.value[x]",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSIPackage"
        }
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "short" : "Marketing Authorization Holder"
      },
      {
        "id" : "Medication.doseForm",
        "path" : "Medication.doseForm",
        "short" : "Dose form. For a branded product, this would most likely be authorised dose form, but it could also be administrable dose form. For package items, it could be item's individual dose form.",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationForm"
            }
          ],
          "strength" : "example",
          "description" : "A coded concept defining the form of a medication.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-form-codes",
          "additional" : [
            {
              "purpose" : "candidate",
              "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSIDoseForm",
              "documentation" : "MyHealth@EU crossborder value set for dose forms. Based on EDQM Standard Terms."
            }
          ]
        }
      },
      {
        "id" : "Medication.totalVolume",
        "path" : "Medication.totalVolume",
        "short" : "Total volume or number of package items inside a package.",
        "definition" : "Total volume or number of package items inside a package. This element should not contain overall prescribed amount, but describe the product itself. In case of complex packages, this element could be left empty, and number of different items could be indicated in the nested Medications."
      },
      {
        "id" : "Medication.ingredient.item",
        "path" : "Medication.ingredient.item",
        "short" : "Substance (Substance resource or concept from terminology) or a medicinal product (Medication resource or concept from terminology). Medicinal product can be an ingredient in case of extemporal medications or combination packs (e.g Creme + 6 tablets)",
        "type" : [
          {
            "code" : "CodeableReference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/medication-eu-core"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/medicine-active-substances-uv-ips",
          "additional" : [
            {
              "purpose" : "candidate",
              "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSISubstance",
              "documentation" : "MyHealth@EU crossborder value set for substances. Based on EMA SPOR SMS."
            }
          ]
        }
      },
      {
        "id" : "Medication.ingredient.strength[x]",
        "path" : "Medication.ingredient.strength[x]",
        "short" : "Amount of substance in product (presentation or concentration strength)",
        "definition" : "Definitional resources should be used for specifying the different types of strengths: presentation; concentration."
      },
      {
        "id" : "Medication.ingredient.strength[x].extension:basisOfStrengthSubstance",
        "path" : "Medication.ingredient.strength[x].extension",
        "sliceName" : "basisOfStrengthSubstance",
        "short" : "Basis of strength substance - substance for which the strength is provided (this could be different from the precise active ingredient).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://profiles.ihe.net/PHARM/MPD/StructureDefinition/ihe-ext-medication-strengthsubstance"
            ]
          }
        ]
      },
      {
        "id" : "Medication.batch.lotNumber",
        "path" : "Medication.batch.lotNumber",
        "short" : "Lot Number"
      },
      {
        "id" : "Medication.batch.expirationDate",
        "path" : "Medication.batch.expirationDate",
        "short" : "Expiration Date"
      }
    ]
  }
}

```
