# Artifacts Summary - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### HL7 Europe Base Profiles 

Base profiles for the European context.

| | |
| :--- | :--- |
| [Organization (EU base)](StructureDefinition-organization-eu.md) | This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context. |
| [Patient (EU base)](StructureDefinition-patient-eu.md) | This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context. |
| [Practitioner (EU base)](StructureDefinition-practitioner-eu.md) | This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context. |
| [PractitionerRole (EU base)](StructureDefinition-practitionerRole-eu.md) | This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context. |

### HL7 Europe Core Profiles 

Core profiles for the European context.

| | |
| :--- | :--- |
| [Allergy Intolerance (EU core)](StructureDefinition-allergyIntolerance-eu-core.md) | This profile sets minimum expectations for the AllergyIntolerance resource common to most of the use cases. |
| [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md) | This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context. |
| [Composition (EU core)](StructureDefinition-composition-eu-core.md) | This profile sets minimum expectations for the Composition resource for commonly used EHDS documents. |
| [Condition (EU core)](StructureDefinition-condition-eu-core.md) | This profile sets minimum expectations for the Condition resource common to most of the use cases. |
| [DiagnosticReport (EU core)](StructureDefinition-diagnosticReport-eu-core.md) | This profile sets minimum expectations for the DiagnosticReport resource for commonly used EHDS documents. |
| [Flag (EU core)](StructureDefinition-flag-eu-core.md) | This profile defines the core constraints and extensions for a Flag resource when used in European systems for communicating warnings, alerts, or reminders about important health information. |
| [Immunization (EU core)](StructureDefinition-immunization-eu-core.md) | This profile sets minimum expectations for the Immunization resource common to most of the use cases. |
| [Location (EU core)](StructureDefinition-location-eu-core.md) | This profile sets minimum expectations for the Location resource to be used for the purpose of this guide. |
| [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md) | This profile sets minimum expectations for the Observation resource for Medical Test Results common to most of the use cases. |
| [Medication (EU core)](StructureDefinition-medication-eu-core.md) | This profile sets minimum expectations for the Medication resource common to most of the use cases. This profile is adapted from the MPD work. |
| [MedicationRequest (EU core)](StructureDefinition-medicationRequest-eu-core.md) | This profile sets minimum expectations for the MedicationRequest resource common to most of the use cases. This profile is adapted from the MPD work. |
| [MedicationStatement (EU core)](StructureDefinition-medicationStatement-eu-core.md) | This profile sets minimum expectations for the MedicationStatement resource common to most of the use cases. This profile is adapted from the MPD work. |
| [Organization (EU core)](StructureDefinition-organization-eu-core.md) | This profile sets minimum expectations for the Organization resource common to most of the use cases. |
| [Patient (EU core)](StructureDefinition-patient-eu-core.md) | This profile sets minimum expectations for the Patient resource common to most of the use cases. When the ips-pat-1 invariant is satisfied (Patient.name.given, Patient.name.family or Patient.name.text SHALL be present) then this profile complies with the IPS patient profile. |
| [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md) | This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide. This is used to identify the species when a specimen is collected from an animal |
| [Practitioner (EU core)](StructureDefinition-practitioner-eu-core.md) | This profile sets minimum expectations for the Practitioner resource common to most of the use cases. |
| [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md) | This profile sets minimum expectations for the PractitionerRole resource common to most of the use cases. |
| [Procedure (EU core)](StructureDefinition-procedure-eu-core.md) | This profile represents the constraints applied to the Procedure resource by this guide. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address (EU)](StructureDefinition-Address-eu.md) | This profile extends the Address data type for supporting streetname, housenumber and postal box. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Body Structure Laterality](ValueSet-siteLaterality-eu.md) | Body Structure site laterality qualifier. It indicates - for example - the body site laterality from which a laboratory specimen is collected. (based on SNOMED CT) |
| [Body Structure Qualifier](ValueSet-siteQualifier-eu.md) | Body Structure site qualifier. It indicates - for example - the body site qualifier from which a laboratory specimen is collected. (based on SNOMED CT) |
| [EHDS Categories](ValueSet-ehdsCategories-eu.md) | EHDS Categories: it indicates the EHDS category that document belongs to. |
| [Laboratory Code](ValueSet-lab-obsCode-eu-lab.md) | Laboratory observation codes. List of Laboratory observation codes containing LOINC and NPU. |
| [Medication Intended Use](ValueSet-medicationIntendedUse-eu.md) | Medication intended use: it indicates the intended use of a medication for a patient (based on SNOMED CT). |
| [Periods of Life](ValueSet-periodsOfLife-eu.md) | Periods of life: it indicates the period of life of a patient (based on SNOMED CT). |
| [Types of species](ValueSet-speciesType-eu.md) | Animal species types for non-human subjects |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AllergyIntolerance Example](AllergyIntolerance-allergyintolerance-eu-core-example.md) | Example of an AllergyIntolerance resource conforming to the AllergyIntolerance (EU Core) profile. |
| [Animal Patient Example](Patient-Patient-animal-example.md) | Example of a Patient resource conforming to the Patient Animal (EU Core) profile. |
| [BodyStructure Example](BodyStructure-example-body-structure-eu.md) | Example of a BodyStructure resource conforming to the BodyStructure (EU) profile. |
| [Composition Example](Composition-26032a57-083a-4ddf-b019-e566ae02f740.md) | Example of a Laboratory Report Composition conforming to the Composition (EU Core) profile. |
| [Condition Example](Condition-condition-eu-core-example.md) | Example of a Condition resource conforming to the Condition (EU Core) profile. |
| [DiagnosticReport Example](DiagnosticReport-5679723c-4fae-4ba7-9f09-5438a827bfda.md) | Example of a Laboratory Report DiagnosticReport conforming to the DiagnosticReport (EU Core) profile. |
| [Flag Example](Flag-flag-eu-core-example.md) | Example of a Flag resource conforming to the Flag (EU Core) profile. |
| [Immunization Example](Immunization-immunization-eu-core-example.md) | Example of an Immunization resource conforming to the Immunization (EU Core) profile. |
| [Location Example](Location-example-location.md) | Example of a Location resource conforming to the Location (EU) profile. |
| [Medication Example](Medication-01A-Cefuroxime1500GenericExplicit.md) | Example of a Medication conforming to the Medication (EU Core) profile. It represents Cefuroxime 1500mg (1.5g) powder for solution in a vial. |
| [MedicationRequest Example](MedicationRequest-400C-prescription-cefuroxime-singleline.md) | Example of a MedicationRequest conforming to the MedicationRequest (EU Core) profile. It is a prescription/request with one medication and changing dosaging. Uses 'actionable' tag. Cefuroxime sodium. |
| [MedicationStatement Example](MedicationStatement-example-medicationstatement-eucore.md) | Example of a MedicationStatement conforming to the MedicationStatement (EU Core) profile. It describes a patient taking Enalapril. |
| [Observation Example](Observation-763f7902-8103-4d10-8bd1-546a726d43ee.md) | Example of a Laboratory Result Observation conforming to the Medical Test Result (EU Core) profile. |
| [Organization Example](Organization-organization-eu-core-example.md) | Example of an Organization resource conforming to the Organization (EU Core) profile. |
| [Patient Example](Patient-patient-eu-core-example.md) | Example of a Patient resource conforming to the Patient (EU Core) profile. |
| [Practitioner Example](Practitioner-practitioner-eu-core-example.md) | Example of a Practitioner resource conforming to the Practitioner (EU Core) profile. |
| [PractitionerRole Example](PractitionerRole-practitionerRole-eu-core-example.md) | Example of a PractitionerRole resource conforming to the PractitionerRole (EU Core) profile. |
| [Procedure Example](Procedure-procedure-eu-core-example.md) | Example of a Procedure resource conforming to the Procedure (EU Core) profile. |
| [ServiceRequest Example](ServiceRequest-1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1.md) | Laboratory Report ServiceRequest resource used by the DiagnosticReport example. |

