# Home - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5 | *Version*:2.0.0-ballot |
| Active as of 2025-12-19 | *Computable Name*:Hl7EuBaseIg |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

This Implementation Guide (IG) brings together **base** and **core** HL7® FHIR® artifacts designed specifically for the European context.

It provides a foundation for interoperability, ensuring reusability across national projects, European initiatives, and derived HL7 Europe guides.

The guide supports:

* Developers and implementers who need common building blocks.
* Policymakers and program leads who require consistent definitions for EHDS-aligned projects.
* Standards experts who wish to build on a harmonized European foundation.

### Introduction

The HL7 Europe Base and Core Implementation Guide provides a **layered approach to FHIR interoperability** in the European context; and it aims to support a coherent and reusable set of FHIR specifications across Europe.

It includes:

* **Base profiles.** Loosely constrained baseline definitions of common European concepts (e.g., Patient, Practitioner). They provide flexibility and serve as the foundation for Core and derived profiles.
* **Core profiles.** More constrained profiles designed for reuse across most European IGs. They introduce essential constraints, can often be used directly, and pursue alignment with IPS.

See the [**Introduction**page](introduction.md) for detailed explanations of Base and Core profiles, their relationship with Extensions and scoped IGs, and their alignment with EHDS and IPS.

**Fig. 1 - European Base and Core profiles**

### Guide Publication

This guide is published for two HL7 FHIR versions:

* **HL7 FHIR R4 Base IG** (hl7.fhir.eu.base). Published at [this link](https://hl7.eu/fhir/base).
* **HL7 FHIR R5 Base IG** (hl7.fhir.eu.base-r5). This Guide.

Both versions are maintained by HL7 Europe and evolve based on community feedback and EHDS requirements.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.eu.base-r5",
  "url" : "http://hl7.eu/fhir/base-r5/ImplementationGuide/hl7.fhir.eu.base-r5",
  "version" : "2.0.0-ballot",
  "name" : "Hl7EuBaseIg",
  "title" : "HL7 Europe Base and Core FHIR IG",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This guide collects base and core profiles to be used in the European context. It also includes common artifacts, such as the profiles describing the European Health Insurance Card.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "packageId" : "hl7.fhir.eu.base-r5",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_eu_extensions_r5",
      "uri" : "http://hl7.eu/fhir/extensions",
      "packageId" : "hl7.fhir.eu.extensions.r5",
      "version" : "1.2.0"
    },
    {
      "id" : "ihe_pharm_mpd",
      "uri" : "https://profiles.ihe.net/PHARM/MPD/ImplementationGuide/ihe.pharm.mpd",
      "packageId" : "ihe.pharm.mpd",
      "version" : "1.0.0-comment-2"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.9.0"
      }
    ],
    "grouping" : [
      {
        "id" : "EuBaseProfiles",
        "name" : "HL7 Europe Base Profiles",
        "description" : "Base profiles for the European context."
      },
      {
        "id" : "EuCoreProfilesSTU1",
        "name" : "HL7 Europe Core Profiles",
        "description" : "Core profiles for the European context."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Address-eu"
        },
        "name" : "Address (EU)",
        "description" : "This profile extends the Address data type for supporting streetname, housenumber and postal box.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/allergyIntolerance-eu-core"
        },
        "name" : "Allergy Intolerance (EU core)",
        "description" : "This profile sets minimum expectations for the AllergyIntolerance resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/allergyintolerance-eu-core-example"
        },
        "name" : "AllergyIntolerance Example",
        "description" : "Example of an AllergyIntolerance resource conforming to the AllergyIntolerance (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/allergyIntolerance-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Patient-animal-example"
        },
        "name" : "Animal Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient Animal (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-animal-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteLaterality-eu"
        },
        "name" : "Body Structure Laterality",
        "description" : "Body Structure site laterality qualifier. It indicates - for example - the body site laterality from which a laboratory specimen is collected. (based on SNOMED CT)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteQualifier-eu"
        },
        "name" : "Body Structure Qualifier",
        "description" : "Body Structure site qualifier. It indicates - for example - the body site qualifier from which a laboratory specimen is collected. (based on SNOMED CT)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bodyStructure-eu-core"
        },
        "name" : "BodyStructure (EU core)",
        "description" : "This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BodyStructure"
          }
        ],
        "reference" : {
          "reference" : "BodyStructure/example-body-structure-eu"
        },
        "name" : "BodyStructure Example",
        "description" : "Example of a BodyStructure resource conforming to the BodyStructure (EU) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/bodyStructure-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-eu-core"
        },
        "name" : "Composition (EU core)",
        "description" : "This profile sets minimum expectations for the Composition resource for commonly used EHDS documents.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/26032a57-083a-4ddf-b019-e566ae02f740"
        },
        "name" : "Composition Example",
        "description" : "Example of a Laboratory Report Composition conforming to the Composition (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/composition-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-eu-core"
        },
        "name" : "Condition (EU core)",
        "description" : "This profile sets minimum expectations for the Condition resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/condition-eu-core-example"
        },
        "name" : "Condition Example",
        "description" : "Example of a Condition resource conforming to the Condition (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/condition-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/diagnosticReport-eu-core"
        },
        "name" : "DiagnosticReport (EU core)",
        "description" : "This profile sets minimum expectations for the DiagnosticReport resource for commonly used EHDS documents.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/5679723c-4fae-4ba7-9f09-5438a827bfda"
        },
        "name" : "DiagnosticReport Example",
        "description" : "Example of a Laboratory Report DiagnosticReport conforming to the DiagnosticReport (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/diagnosticReport-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ehdsCategories-eu"
        },
        "name" : "EHDS Categories",
        "description" : "EHDS Categories: it indicates the EHDS category that document belongs to.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/flag-eu-core"
        },
        "name" : "Flag (EU core)",
        "description" : "This profile defines the core constraints and extensions for a Flag resource when used in European systems for communicating warnings, alerts, or reminders about important health information.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Flag"
          }
        ],
        "reference" : {
          "reference" : "Flag/flag-eu-core-example"
        },
        "name" : "Flag Example",
        "description" : "Example of a Flag resource conforming to the Flag (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/flag-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/immunization-eu-core"
        },
        "name" : "Immunization (EU core)",
        "description" : "This profile sets minimum expectations for the Immunization resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/immunization-eu-core-example"
        },
        "name" : "Immunization Example",
        "description" : "Example of an Immunization resource conforming to the Immunization (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/immunization-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/lab-obsCode-eu-lab"
        },
        "name" : "Laboratory Code",
        "description" : "Laboratory observation codes. List of Laboratory observation codes containing LOINC and NPU.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/location-eu-core"
        },
        "name" : "Location (EU core)",
        "description" : "This profile sets minimum expectations for the Location resource to be used for the purpose of this guide.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-location"
        },
        "name" : "Location Example",
        "description" : "Example of a Location resource conforming to the Location (EU) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/location-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicalTestResult-eu-core"
        },
        "name" : "MedicalTestResult (EU core)",
        "description" : "This profile sets minimum expectations for the Observation resource for Medical Test Results common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-eu-core"
        },
        "name" : "Medication (EU core)",
        "description" : "This profile sets minimum expectations for the Medication resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01A-Cefuroxime1500GenericExplicit"
        },
        "name" : "Medication Example",
        "description" : "Example of a Medication conforming to the Medication (EU Core) profile. It represents  Cefuroxime 1500mg (1.5g) powder for solution in a vial.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/medication-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationIntendedUse-eu"
        },
        "name" : "Medication Intended Use",
        "description" : "Medication intended use: it indicates the intended use of a medication for a patient (based on SNOMED CT).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationRequest-eu-core"
        },
        "name" : "MedicationRequest (EU core)",
        "description" : "This profile sets minimum expectations for the MedicationRequest resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/400C-prescription-cefuroxime-singleline"
        },
        "name" : "MedicationRequest Example",
        "description" : "Example of a MedicationRequest conforming to the MedicationRequest (EU Core) profile. \nIt is a prescription/request with one medication and changing dosaging. Uses 'actionable' tag. Cefuroxime sodium.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/medicationRequest-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationStatement-eu-core"
        },
        "name" : "MedicationStatement (EU core)",
        "description" : "This profile sets minimum expectations for the MedicationStatement resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/example-medicationstatement-eucore"
        },
        "name" : "MedicationStatement Example",
        "description" : "Example of a MedicationStatement conforming to the MedicationStatement (EU Core) profile. It describes a patient taking Enalapril.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/medicationStatement-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/763f7902-8103-4d10-8bd1-546a726d43ee"
        },
        "name" : "Observation Example",
        "description" : "Example of a Laboratory Result Observation conforming to the Medical Test Result (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu"
        },
        "name" : "Organization (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu-core"
        },
        "name" : "Organization (EU core)",
        "description" : "This profile sets minimum expectations for the Organization resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/organization-eu-core-example"
        },
        "name" : "Organization Example",
        "description" : "Example of an Organization resource conforming to the Organization (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu"
        },
        "name" : "Patient (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu-core"
        },
        "name" : "Patient (EU core)",
        "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases.\nWhen the ips-pat-1 invariant is satisfied \\(Patient.name.given, Patient.name.family or Patient.name.text SHALL be present\\) then this profile complies with the IPS patient profile.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient-eu-core-example"
        },
        "name" : "Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient (EU Core) profile.",
        "isExample" : true,
        "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-animal-eu-core"
        },
        "name" : "Patient: Animal (EU core)",
        "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/periodsOfLife-eu"
        },
        "name" : "Periods of Life",
        "description" : "Periods of life: it indicates the period of life of a patient (based on SNOMED CT).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu"
        },
        "name" : "Practitioner (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu-core"
        },
        "name" : "Practitioner (EU core)",
        "description" : "This profile sets minimum expectations for the Practitioner resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner-eu-core-example"
        },
        "name" : "Practitioner Example",
        "description" : "Example of a Practitioner resource conforming to the Practitioner (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu"
        },
        "name" : "PractitionerRole (EU base)",
        "description" : "This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context.",
        "isExample" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu-core"
        },
        "name" : "PractitionerRole (EU core)",
        "description" : "This profile sets minimum expectations for the PractitionerRole resource common to most of the use cases.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/practitionerRole-eu-core-example"
        },
        "name" : "PractitionerRole Example",
        "description" : "Example of a PractitionerRole resource conforming to the PractitionerRole (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-eu-core"
        },
        "name" : "Procedure (EU core)",
        "description" : "This profile represents the constraints applied to the Procedure resource by this guide.",
        "isExample" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/procedure-eu-core-example"
        },
        "name" : "Procedure Example",
        "description" : "Example of a Procedure resource conforming to the Procedure (EU Core) profile.",
        "isExample" : true,
        "profile" : [
          "http://hl7.eu/fhir/base-r5/StructureDefinition/procedure-eu-core"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1"
        },
        "name" : "ServiceRequest Example",
        "description" : "Laboratory Report ServiceRequest resource used by the DiagnosticReport example.",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/speciesType-eu"
        },
        "name" : "Types of species",
        "description" : "Animal species types for non-human subjects",
        "isExample" : false
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "authors.html",
          "name" : "authors.html",
          "title" : "Authors and Contributors",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "copyright.html",
          "name" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "crossversionanalysis.html",
          "name" : "crossversionanalysis.html",
          "title" : "Cross-version Analysis",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "dependencies.html",
          "name" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "knownissues.html",
          "name" : "knownissues.html",
          "title" : "Known/Open Issues",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "introduction.html",
          "name" : "introduction.html",
          "title" : "Introduction",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "modelmap.html",
          "name" : "modelmap.html",
          "title" : "Model Map",
          "generation" : "html"
        },
        {
          "sourceUrl" : "logicalmodels.html",
          "name" : "logicalmodels.html",
          "title" : "Logical Models",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "missing-data.html",
          "name" : "missing-data.html",
          "title" : "Handling Missing Data",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "map-ehdsaddress.html",
          "name" : "map-ehdsaddress.html",
          "title" : "EHDSAddress to FHIR Address Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsbodystructure.html",
          "name" : "map-ehdsbodystructure.html",
          "title" : "EHDSBodyStructure to FHIR BodyStructure Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdshealthprofessional.html",
          "name" : "map-ehdshealthprofessional.html",
          "title" : "EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsorganisation.html",
          "name" : "map-ehdsorganisation.html",
          "title" : "EHDSOrganisation to FHIR Organization Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdslocation.html",
          "name" : "map-ehdslocation.html",
          "title" : "EHDSLocation to FHIR Location Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdshumanname.html",
          "name" : "map-ehdshumanname.html",
          "title" : "EHDSHumanName to FHIR HumanName Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdspatient.html",
          "name" : "map-ehdspatient.html",
          "title" : "EHDSPatient to FHIR Patient Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdspatientanimal.html",
          "name" : "map-ehdspatientanimal.html",
          "title" : "EHDSPatientAnimal to FHIR Patient (Animal) Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdstelecom.html",
          "name" : "map-ehdstelecom.html",
          "title" : "EHDSTelecom to FHIR ContactPoint Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsalert.html",
          "name" : "map-ehdsalert.html",
          "title" : "EHDSAlert to FHIR Flag Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsallergyintolerance.html",
          "name" : "map-ehdsallergyintolerance.html",
          "title" : "EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdscondition.html",
          "name" : "map-ehdscondition.html",
          "title" : "EHDSCondition to FHIR Condition Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsobservation.html",
          "name" : "map-ehdsobservation.html",
          "title" : "EHDSObservation to FHIR Observation Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsprocedure.html",
          "name" : "map-ehdsprocedure.html",
          "title" : "EHDSProcedure to FHIR Procedure Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsimmunisation.html",
          "name" : "map-ehdsimmunisation.html",
          "title" : "EHDSImmunisation to FHIR Immunization Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsdocument.html",
          "name" : "map-ehdsdocument.html",
          "title" : "EHDSDocument to FHIR Composition Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsdocument-report.html",
          "name" : "map-ehdsdocument-report.html",
          "title" : "EHDSDocument to FHIR DiagnosticReport Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsmedication.html",
          "name" : "map-ehdsmedication.html",
          "title" : "EHDSMedication to FHIR Medication Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsmedicationstatement.html",
          "name" : "map-ehdsmedicationstatement.html",
          "title" : "EHDSMedicationStatement to FHIR MedicationStatement Mapping",
          "generation" : "html"
        },
        {
          "sourceUrl" : "map-ehdsmedicationprescription.html",
          "name" : "map-ehdsmedicationprescription.html",
          "title" : "EHDSMedicationprescription to FHIR MedicationRequest Mapping",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2024+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "ballot"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "http://terminology.hl7.eu/CodeSystem/v3-ActCode"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/pagecontent"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/pagecontent/model-maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "show-inherited-invariants"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "usage-stats-opt-out"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "ips-comparison"
        },
        "value" : "2.0.0"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://hl7.eu/fhir/base-r5/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
