# EHDSDocument to FHIR Composition Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSDocument to FHIR Composition Mapping**

## EHDSDocument to FHIR Composition Mapping

# EHDSDocument ↔ Composition

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSDocument ↔ Composition

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR CompositionEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSDocument](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSDocument.html) 
*  **Target FHIR profile:** [CompositionEuCore](StructureDefinition-composition-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Document header elements. | related-to | Composition | . | General metadata. | Dataset-level information across the Composition instance.**Category (classCode) is missing ?** |
| header.subject | Patient/subject information. | equivalent | Composition | subject | Who or what the composition is about. | Reference to Patient. |
| header.identifier | Unique identifier of the document. | equivalent | Composition | identifier | Version-independent identifier for the Composition | Multiple identifiers allowed; Composition R4 allows 0..1, R5 0..*.`setId`in HL7 CDA |
| header.identifier | Unique identifier of the document. | equivalent | Bundle | identifier | Persistent identifier for the bundle | Identifier of a specifc version of this document.`id`in HL7 CDA |
| header.authorship | Resource authoring details. | related-to | Composition | author | Authors | Composition.date is the time of composition; see child elements. |
| header.authorship.author[x] | Author(s) who authored the resource. | equivalent | Composition | author | List of logical authors. | Reference to Practitioner / PractitionerRole / Organization / Device. |
| header.authorship.datetime | Date and time of authoring/issuing. | equivalent | Composition | date | Composition creation time. |  |
| header.lastUpdate | Date/time of last technical update. | equivalent | Composition | meta.lastUpdated | System-level modification time. | The map applies only in case it represents when the resource was last updated. It is an Instant (i.e. YYYY-MM-DDThh:mm:ss.sss+zz:zz ) |
| header.status | Status of the resource or document. | equivalent | Composition | status | The workflow/clinical status of this composition |  |
| header.statusReason[x] | Reason for the current status. | no-map | Composition |  |  | No native element |
| header.language | Language of the resource (IETF BCP-47). | equivalent | Composition | language | Language of the narrative. |  |
| header.documentType | Type of document (e.g., LOINC 60591-5). | equivalent | Composition | type | Kind of composition (LOINC preferred). |  |
| header.documentTitle | Human readable document title. | equivalent | Composition | title | Official human-readable label. |  |
| header.period | Time of service being documented. | related-to | Composition | event.period | Period covered by the composition content. | Map to the primary Composition.event entry. |
| header.version | Business version of the document. | related-to | Composition | extension:version〔R4〕 | Document business version. | Use Composition.version extension (pre-adopt R5 extension). |
| header.version | Business version of the document. | related-to | Composition | version〔R5〕 | Document business version. |  |
| header.attestation | Document attestation details. | related-to | Composition | attester | Participants responsible for attesting the composition. | Use mode to distinguish assertions. |
| header.attestation.attester | Attester who validated the document. | equivalent | Composition | attester.party | Who attested the composition. |  |
| header.attestation.datetime | Date/time of approval by attester. | equivalent | Composition | attester.time | When the composition was attested. | Set attester.mode as appropriate (e.g., professional). |
| header.legalAuthentication | Document legal authentication details. | related-to | Composition | attester | Legal authenticator. | Use attester.mode = "legal" for the legal authenticator. |
| header.legalAuthentication.legalAuthenticator | Person responsible for medical content. | related-to | Composition | attester.party | Legal authenticator party. | Use attester.mode = "legal" for the legal authenticator. |
| header.legalAuthentication.datetime | Date/time when the document was authorised. | equivalent | Composition | attester.time | When the composition was attested. | Use attester.mode = "legal" for the legal authenticator. |
| header.eventType | Categorisation of the event covered by the document. | relatedTo | Composition | event.code | Codes describing the event(s) related to the composition. | Clarify the scope. If it is a classificaiton of the document it should be category |
| header.serviceSpecialty | Details about where the content was created (clinical specialty). | source-is-narrower-than-target | Composition | category | Categorizes the composition. | Use category to tag specialty if no dedicated extension/profile element exists.**(1) Is this a metadata information or something that have to be captured in the document ? (2) is this only for diagnosti reports ? in thsi case we can use DiagnosticReport.category** |
| header.custodian | Organisation maintaining the document/report. | equivalent | Composition | custodian | Organization responsible for maintenance. | Reference to Organization. |
| header.confidentiality | Level of confidentiality (implicit normal). | equivalent | Composition | confidentiality | As defined by confidentiality codes. |  |
| presentedForm | Narrative easy-to-read representation (e.g., PDF). | no-map | Composition |  |  | To be determined |

 Return to overview: [EHDS Logical Models ↔ FHIR Profiles](modelmap.md) 

