# EHDSMedicationStatement to FHIR MedicationStatement Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSMedicationStatement to FHIR MedicationStatement Mapping**

## EHDSMedicationStatement to FHIR MedicationStatement Mapping

# EHDSMedicationStatement → MedicationStatement

**Context**Xt-EHR currently has no dedicated common model for
`MedicationRequest`. For that reason, this mapping is based on the prescription model realised by the HL7 Europe Medication Prescription and Dispense (MPD) FHIR Implementation Guide (
[https://hl7.eu/fhir/mpd](https://hl7.eu/fhir/mpd)).

### EHDSMedicationStatement → MedicationStatement

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR MedicationStatement profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSMedicationStatement](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSMedicationStatement.html) 
*  **Target FHIR profile:** [MedicationStatementEuCore](StructureDefinition-medicationStatement-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | MedicationStatement | . | General metadata. | Dataset-level; not usually carried in MedicationStatement as-is. |
| header.subject | Patient/subject of the statement. | equivalent | MedicationStatement | subject | Who is/was taking the medication. | Reference to Patient. |
| header.identifier | Business identifier for the object. | equivalent | MedicationStatement | identifier | Identifiers for this statement. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details. | no map | MedicationStatement |  |  | Waiting for Xt-EHR feedback |
| header.authorship.author[x] | Author(s) of the statement. | no map | MedicationStatement |  |  | Waiting for Xt-EHR feedback |
| header.authorship.datetime | Date/time of authoring/issuing. | no map | MedicationStatement |  |  | Waiting for Xt-EHR feedback |
| header.lastUpdate | Last technical correction/update. | related-to | MedicationStatement | meta.lastUpdated | When the resource version last changed. | The map applies only if it represents the technical update timestamp (Instant). |
| header.status | Status of the resource/document. | related-to | MedicationStatement | status | Position in the medication use lifecycle. | What is the difference with medicationTreatmentStatus ? |
| header.statusReason[x] | Reason for the current status. | source-is-broader-than-target | MedicationStatement | statusReason〔R4〕 | Reason for current status | Not in R5. The model allows for CodeableConcept and string. The target only CodeableConcept. |
| header.statusReason[x] | Reason for the current status. | no-map | MedicationStatement | 〔R5〕 |  | Not in R5. Should be removed it ? |
| header.language | Language of the resource (IETF tag). | equivalent | MedicationStatement | language | Language used in the resource. |  |
| medicationTreatmentStatus | The current status of the taking of medicine. | equivalent | MedicationStatement | extension:adherence.code〔R4〕 | Type of adherence |  |
| medicationTreatmentStatus | The current status of the taking of medicine. | equivalent | MedicationStatement | adherence.code〔R5〕 | Type of adherence |  |
| medication | Describes the medicinal product. | equivalent | MedicationStatement | medication[x]〔R4〕 | Medication expressed as a reference. | In the model only the Reference to`Medication`. |
| medication | Describes the medicinal product. | equivalent | MedicationStatement | medication〔R5〕 | Medication expressed as a reference. | In the model only the Reference to`Medication`. |
| medicationReason | Coded reason for use (diagnosis/procedure). | equivalent | MedicationStatement | reasonCode〔R4〕 | Reason for why the medication is/was taken. |  |
| medicationReason | Coded reason for use (diagnosis/procedure). | equivalent | MedicationStatement | reason.concept〔R5〕 | Reason for why the medication is/was taken. |  |
| medicationReasonText | Free-text reason for use. | related-to | MedicationStatement | reasonCode.text〔R4〕 | Textual reason for medication use. | Alternatively convey as`note`if preferred. |
| medicationReasonText | Free-text reason for use. | related-to | MedicationStatement | reason.concept.text〔R5〕 | Textual reason for medication use. |  |
| intendedUseType | Type of intended use (prophylactic, therapeutic, etc.). | source-is-narrower-than-target | MedicationStatement | category | Classification of statement. |  |
| dosageInstructions | Details of how medication is/was taken. | equivalent | MedicationStatement | dosage | Dosage instructions. | Map each EHDSDosaging row to a`dosage`element. |
| periodOfUse | Period when the medication is/was used. | equivalent | MedicationStatement | effectivePeriod | Time period the statement covers. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

