# BodyStructure Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BodyStructure Example**

## Example BodyStructure: BodyStructure Example

Profile: [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md)

**morphology**: Blister

### IncludedStructures

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Structure** | **Laterality** | **Qualifier** |
| * | Wrist | Left | Below |

**patient**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)



## Resource Content

```json
{
  "resourceType" : "BodyStructure",
  "id" : "example-body-structure-eu",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/bodyStructure-eu-core"
    ]
  },
  "morphology" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "339008",
        "display" : "Blister"
      }
    ]
  },
  "includedStructure" : [
    {
      "structure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "8205005",
            "display" : "Wrist"
          }
        ]
      },
      "laterality" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        ]
      },
      "qualifier" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "351726001",
              "display" : "Below"
            }
          ]
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/patient-eu-core-example"
  }
}

```
