# Flag Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Flag Example**

## Example Flag: Flag Example

Profile: [Flag (EU core)](StructureDefinition-flag-eu-core.md)

**status**: Active

**category**: Safety

**code**: At risk of falls

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**period**: 2024-01-10 --> (ongoing)



## Resource Content

```json
{
  "resourceType" : "Flag",
  "id" : "flag-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/flag-eu-core"
    ]
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/flag-category",
          "code" : "safety",
          "display" : "Safety"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "129839007",
        "display" : "At risk of falls"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "period" : {
    "start" : "2024-01-10"
  }
}

```
