# MedicationStatement Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatement Example**

## Example MedicationStatement: MedicationStatement Example

**Medication:** Enalapril 20mg tablets

**Patient:** Fiona XXX_Swart

**Status:** Active

**Dosage:** Take one tablet daily in the morning (oral route)

**Informant:** Dr. Lukas Müller

**Date Asserted:** 2024-12-01



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "example-medicationstatement-eucore",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/medicationStatement-eu-core"
    ]
  },
  "status" : "recorded",
  "medication" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "C09AA02",
          "display" : "Enalapril"
        }
      ],
      "text" : "Enalapril 20mg tablets"
    }
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example",
    "display" : "John Doe"
  },
  "effectiveDateTime" : "2024-12-01",
  "dateAsserted" : "2024-12-01",
  "informationSource" : [
    {
      "reference" : "Patient/patient-eu-core-example",
      "display" : "Luigi De Luca"
    }
  ],
  "dosage" : [
    {
      "text" : "Take one tablet daily in the morning",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 20,
            "unit" : "mg",
            "system" : "http://unitsofmeasure.org",
            "code" : "mg"
          }
        }
      ]
    }
  ]
}

```
