# Observation Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Example**

## Example Observation: Observation Example

Profile: [MedicalTestResult (EU core)](StructureDefinition-medicalTestResult-eu-core.md)

**status**: Final

**category**: Laboratory

**code**: Urea (U) [Moles/Vol]

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**effective**: 2023-03-27 11:24:26+0100

**performer**: Jan Laborant

**value**: 310 mmol/L(Details: UCUM codemmol/L = 'mmol/L')

**interpretation**: Significantly low

**method**: Spectrophotometric technique

**specimen**: Urine specimen

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 67 mmol/L | 580 mmol/L | Normal Range |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "763f7902-8103-4d10-8bd1-546a726d43ee",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/medicalTestResult-eu-core"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "22700-9",
        "display" : "Urea [Moles/volume] in Urine"
      }
    ],
    "text" : "Urea (U) [Moles/Vol]"
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "effectiveDateTime" : "2023-03-27T11:24:26+01:00",
  "performer" : [
    {
      "display" : "Jan Laborant"
    }
  ],
  "valueQuantity" : {
    "value" : 310,
    "unit" : "mmol/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mmol/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "LU",
          "display" : "Significantly low"
        }
      ]
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "70621000052105",
        "display" : "Spectrophotometric technique"
      }
    ]
  },
  "specimen" : {
    "display" : "Urine specimen"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 67,
        "unit" : "mmol/L"
      },
      "high" : {
        "value" : 580,
        "unit" : "mmol/L"
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
            "code" : "normal",
            "display" : "Normal Range"
          }
        ]
      }
    }
  ]
}

```
