# PractitionerRole Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole Example**

## Example PractitionerRole: PractitionerRole Example

Profile: [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md)

**active**: true

**practitioner**: [Practitioner John Doe](Practitioner-practitioner-eu-core-example.md)

**organization**: [Organization Example Health Organization](Organization-organization-eu-core-example.md)

**code**: General practice (specialty)

**specialty**: General medical practice



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "practitionerRole-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu-core"
    ]
  },
  "active" : true,
  "practitioner" : {
    "reference" : "Practitioner/practitioner-eu-core-example"
  },
  "organization" : {
    "reference" : "Organization/organization-eu-core-example"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "394814009",
          "display" : "General practice (specialty)"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "408443003",
          "display" : "General medical practice"
        }
      ]
    }
  ]
}

```
