# Condition (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition (EU core)**

## Resource Profile: Condition (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/condition-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ConditionEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Condition resource common to most of the use cases. 

**Usages:**

* Refer to this Profile: [Procedure (EU core)](StructureDefinition-procedure-eu-core.md)
* Examples for this Profile: [Condition/condition-eu-core-example](Condition-condition-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/condition-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-condition-eu-core.csv), [Excel](StructureDefinition-condition-eu-core.xlsx), [Schematron](StructureDefinition-condition-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "condition-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/condition-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "ConditionEuCore",
  "title" : "Condition (EU core)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Condition resource common to most of the use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.text",
        "path" : "Condition.text",
        "definition" : "Human readable specification of the problem. This is a general notes/comments entry for description of the problem, its diagnosis and prognosis."
      },
      {
        "id" : "Condition.extension",
        "path" : "Condition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.extension:assertedDate",
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:assertedDate.value[x]",
        "path" : "Condition.extension.value[x]",
        "short" : "Date and time of the diagnosis assertion"
      },
      {
        "id" : "Condition.extension:relatedArtifact",
        "path" : "Condition.extension",
        "sliceName" : "relatedArtifact",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/artifact-relatedArtifact"
            ]
          }
        ]
      },
      {
        "id" : "Condition.identifier",
        "path" : "Condition.identifier",
        "definition" : "Globally unique identifier of this problem which remain constant as the resource is updated and propagates from server to server."
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "definition" : "The problem status describes the condition of the problem:\n\r\r\n1.\tActive problems are problems of which the patient experiences symptoms or for which evidence exists.\n\r\r\n2.\tIf condition is abated, then clinicalStatus must be either inactive, resolved, or remission. \n\r\r\n3.\tProblems with the status 'Inactive' refer to problems that don't affect the patient anymore or that of which there is no evidence of existence anymore.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical"
        }
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "definition" : "The verification status to support the clinical status of the condition.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-ver-status"
        }
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "short" : "Category"
      },
      {
        "id" : "Condition.severity",
        "path" : "Condition.severity",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-severity"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/problems-uv-ips",
          "additional" : [
            {
              "purpose" : "candidate",
              "valueSet" : "http://terminology.ehdsi.eu/ValueSet/eHDSIIllnessandDisorder",
              "documentation" : "Additional conformance binding to a problem code when ICD-10 or Orphanet codes are used."
            }
          ]
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Condition.bodySite.extension:bodySite",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "bodySite",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/bodySite"]
          }
        ]
      },
      {
        "id" : "Condition.bodySite.extension:bodySite.value[x]",
        "path" : "Condition.bodySite.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/bodyStructure-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Condition.subject.reference",
        "path" : "Condition.subject.reference",
        "min" : 1
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.onset[x]:onsetDateTime",
        "path" : "Condition.onset[x]",
        "sliceName" : "onsetDateTime",
        "definition" : "Onset of the symptom, complaint, functional limitation, complication or date of diagnosis. A ‘vague’ date, such as only the year or the month and the year, is permitted.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.abatement[x]",
        "path" : "Condition.abatement[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.abatement[x]:abatementDateTime",
        "path" : "Condition.abatement[x]",
        "sliceName" : "abatementDateTime",
        "definition" : "The date or estimated date that the condition resolved or went into remission. A ‘vague’ date, such as only the year or the month and the year, is permitted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Condition.recordedDate",
        "path" : "Condition.recordedDate",
        "short" : "Date when the condition record was created"
      },
      {
        "id" : "Condition.participant.actor",
        "path" : "Condition.participant.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitionerRole-eu",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/practitioner-eu",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.eu/fhir/base-r5/StructureDefinition/organization-eu-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "Condition.stage",
        "path" : "Condition.stage",
        "short" : "Stage/grade"
      },
      {
        "id" : "Condition.stage.summary",
        "path" : "Condition.stage.summary",
        "short" : "Most recent Stage Group"
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "definition" : "Reference to the evidence on which the staging assessment is based."
      },
      {
        "id" : "Condition.stage.type",
        "path" : "Condition.stage.type",
        "short" : "Staging system used."
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "definition" : "Comment by the one who determined or updated the Problem."
      }
    ]
  }
}

```
