# Patient (EU base) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient (EU base)**

## Resource Profile: Patient (EU base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PatientEu |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context. 

### Sex and Gender extensions

#### Sex Parameters for Clinical Use

Sex Parameters for Clinical Use (SPCU) may be used in specific clinical contexts. However, there are cases where having a context-free categorisation of a patient can be useful. When using SPCU at a patient level, consider if any information is available suggesting that the patient is NOT male-typical or female-typical across all clinical contexts, then using specified as the patient-level SPCU is most appropriate.

#### Gender Identity

This represents an individual’s identity, ascertained by asking them what that identity is. The standard extension supports multiple gender identities, with relevant periods to account for a patient’s gender identity changing over time.

#### Pronouns

The pronouns to use when referring to an individual in verbal or written communication.

More details about these and other sex/gender related extensions can be found in the [HL7 Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1](https://hl7.org/xprod/ig/uv/gender-harmony/).

**Usages:**

* Derived from this Profile: [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md) and [Patient (EU core)](StructureDefinition-patient-eu-core.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base-r5|current/StructureDefinition/patient-eu)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-eu.csv), [Excel](StructureDefinition-patient-eu.xlsx), [Schematron](StructureDefinition-patient-eu.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-eu",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base-r5/StructureDefinition/patient-eu",
  "version" : "2.0.0-ballot",
  "name" : "PatientEu",
  "title" : "Patient (EU base)",
  "status" : "active",
  "date" : "2025-12-19T19:52:30+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:birthPlace",
        "path" : "Patient.extension",
        "sliceName" : "birthPlace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/patient-birthPlace"]
          }
        ]
      },
      {
        "id" : "Patient.extension:birthPlace.value[x]",
        "path" : "Patient.extension.value[x]",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu"]
          }
        ]
      },
      {
        "id" : "Patient.extension:sex-for-clinical-use",
        "path" : "Patient.extension",
        "sliceName" : "sex-for-clinical-use",
        "short" : "Sex for clinical use",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-sexParameterForClinicalUse"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:gender-identity",
        "path" : "Patient.extension",
        "sliceName" : "gender-identity",
        "short" : "Gender identity",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:pronouns",
        "path" : "Patient.extension",
        "sliceName" : "pronouns",
        "short" : "Pronouns",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/individual-pronouns"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:patient-citizenship",
        "path" : "Patient.extension",
        "sliceName" : "patient-citizenship",
        "short" : "Citizenship",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:patient-nationality",
        "path" : "Patient.extension",
        "sliceName" : "patient-nationality",
        "short" : "Nationality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-nationality"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:birthTime",
        "path" : "Patient.extension",
        "sliceName" : "birthTime",
        "short" : "Birth time",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/patient-birthTime"]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "short" : "Patient identifiers"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "requirements" : "Need to be able to track the patient by multiple names. Examples are your official name and a partner name.\r\nThe Alphabetic representation of the name SHALL be always provided"
      },
      {
        "id" : "Patient.name.text",
        "path" : "Patient.name.text",
        "short" : "Text representation of the full name.",
        "definition" : "Text representation of the full name. Due to the cultural variance around the world a consuming system may not know how to present the name correctly; moreover not all the parts of the name go in given or family. Creators are therefore strongly encouraged to provide through this element a presented version of the name. Future versions of this guide may require this element."
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "short" : "Family name.",
        "definition" : "Family name. When more the family is composed by more than one names, this element documents the full composed family name with the proper * name.familyrder. The parts are recorded in the fhater and mother family names extensions.",
        "example" : [
          {
            "label" : "spanish",
            "valueString" : "Valero Iglesias"
          }
        ]
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "short" : "Given names. Includes middle names"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "A contact detail for the patient"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "short" : "Administrative Gender"
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "The date of birth for the patient"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu"]
          }
        ]
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "short" : "Marital status"
      },
      {
        "id" : "Patient.contact.relationship",
        "path" : "Patient.contact.relationship",
        "short" : "Contact relationship"
      },
      {
        "id" : "Patient.contact.name",
        "path" : "Patient.contact.name",
        "short" : "Contact name"
      },
      {
        "id" : "Patient.contact.telecom",
        "path" : "Patient.contact.telecom",
        "short" : "Contact details for the person"
      },
      {
        "id" : "Patient.contact.address",
        "path" : "Patient.contact.address",
        "short" : "Contact person address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.eu/fhir/base-r5/StructureDefinition/Address-eu"]
          }
        ]
      },
      {
        "id" : "Patient.communication.language",
        "path" : "Patient.communication.language",
        "short" : "Communication language"
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "Patient's nominated primary care provider."
      }
    ]
  }
}

```
