# EHDSBodyStructure to FHIR BodyStructure Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSBodyStructure to FHIR BodyStructure Mapping**

## EHDSBodyStructure to FHIR BodyStructure Mapping

# EHDSBodyStructure → BodyStructureEuCore

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSBodyStructure → BodyStructureEuCore

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR BodyStructureEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSBodyStructure](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSBodyStructure) 
*  **Target FHIR profile:** [BodyStructureEuCore](StructureDefinition-bodyStructure-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| identifier | Identifier for this instance of the anatomical structure. | equivalent | BodyStructure | identifier | BodyStructure identifier. |  |
| morphology | Kind of structure represented (normal/abnormal morphology). | equivalent | BodyStructure | morphology | Kind of structure. |  |
| location | Body site. | equivalent | BodyStructure | location〔R4〕 | Body site. | R4 commonly uses location; R5 often uses includedStructure.structure. |
| location | Body site. | equivalent | BodyStructure | includedStructure.structure〔R5〕 | Body site. | R4 commonly uses location; R5 often uses includedStructure.structure. |
| locationQualifier | Qualifier for the body site (upper, lower, etc.). | equivalent | BodyStructure | locationQualifier〔R4〕 | Body site modifier. | R4: locationQualifier; R5: includedStructure.qualifier. |
| locationQualifier | Qualifier for the body site (upper, lower, etc.). | equivalent | BodyStructure | includedStructure.qualifier〔R5〕 | Body site modifier. | R4: locationQualifier; R5: includedStructure.qualifier. |
| laterality | Laterality (e.g. left, right). | equivalent | BodyStructure | extension:laterality〔R4〕 | Body structure laterality. | R4 often uses an extension; R5 includes laterality directly. |
| laterality | Laterality (e.g. left, right). | equivalent | BodyStructure | includedStructure.laterality〔R5〕 | Body structure laterality. | R4 often uses an extension; R5 includes laterality directly. |
| description | Textual description of the body structure. | equivalent | BodyStructure | text | Text summary of the resource, for human interpretation. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

