# EHDSLocation to FHIR Location Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSLocation to FHIR Location Mapping**

## EHDSLocation to FHIR Location Mapping

# EHDSLocation → LocationEuCore

> The content of this page is automatically generated and doesn't document the actual mapping.Please don't use this material for implementation purposes !

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSLocation → LocationEuCore

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR LocationEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSLocation](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSLocation) 
*  **Target FHIR profile:** [LocationEuCore](StructureDefinition-location-eu-core.md) 

 LocationEuCore represents physical service delivery sites and care locations. 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| identifier | Identifier for the location. | equivalent | Location | identifier | Unique code or number identifying the location. |  |
| name | Human-readable name of the location. | equivalent | Location | name | Location name. |  |
| description | Textual description of the location and its purpose. | equivalent | Location | description | Description of the location. |  |
| telecom | Contact channels for the location (phone, fax, email, etc.). | equivalent | Location | telecom〔R4〕 | Location telecom / official contact details. | In R4 this is usually telecom; in R5, contact info may live under contact.telecom. |
| telecom | Contact channels for the location (phone, fax, email, etc.). | equivalent | Location | contact.telecom〔R5〕 | Location telecom / official contact details. | In R4 this is usually telecom; in R5, contact info may live under contact.telecom. |
| type | Type/category of the location (e.g. ward, lab, pharmacy counter). | equivalent | Location | physicalType〔R4〕 | Type of location. | In R4, physicalType is common; R5 shifts emphasis to type. |
| type | Type/category of the location (e.g. ward, lab, pharmacy counter). | equivalent | Location | type〔R5〕 | Type of location. | In R4, physicalType is common; R5 shifts emphasis to type. |
| address | Physical postal address of the location. | equivalent | Location | address | Address of the location. | Uses Address/AddressEu. |
| managingOrganisation | Organisation responsible for the services provided at this location. | equivalent | Location | managingOrganization | Managing organization. | Reference to OrganizationEuCore. |
| partOf | Parent/host location of which this one is a physical part. | equivalent | Location | partOf | Another Location that contains this one. | Supports hierarchical location trees. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

