# BodyStructure (EU core) - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BodyStructure (EU core)**

## Resource Profile: BodyStructure (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/bodyStructure-eu-core | *Version*:0.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:BodyStructureEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context. 

**Usages:**

* Examples for this Profile: [BodyStructure/example-body-structure-eu](BodyStructure-example-body-structure-eu.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/bodyStructure-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-bodyStructure-eu-core.csv), [Excel](StructureDefinition-bodyStructure-eu-core.xlsx), [Schematron](StructureDefinition-bodyStructure-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "bodyStructure-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/bodyStructure-eu-core",
  "version" : "0.1.0",
  "name" : "BodyStructureEuCore",
  "title" : "BodyStructure (EU core)",
  "status" : "active",
  "date" : "2025-10-26T21:01:28+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "openehr",
      "uri" : "http://openehr.org",
      "name" : "Open EHR Archetype Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "BodyStructure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/BodyStructure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "BodyStructure",
        "path" : "BodyStructure"
      },
      {
        "id" : "BodyStructure.text",
        "path" : "BodyStructure.text",
        "short" : "Textual description of the body structure"
      },
      {
        "id" : "BodyStructure.extension",
        "path" : "BodyStructure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "BodyStructure.extension:laterality",
        "path" : "BodyStructure.extension",
        "sliceName" : "laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-BodyStructure.includedStructure.laterality"
            ]
          }
        ]
      },
      {
        "id" : "BodyStructure.extension:laterality.value[x]",
        "path" : "BodyStructure.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base/ValueSet/siteLaterality-eu"
        }
      },
      {
        "id" : "BodyStructure.identifier",
        "path" : "BodyStructure.identifier",
        "short" : "Body structure identifier"
      },
      {
        "id" : "BodyStructure.morphology",
        "path" : "BodyStructure.morphology",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/bodystructure-code"
        }
      },
      {
        "id" : "BodyStructure.location",
        "path" : "BodyStructure.location",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "BodyStructure.locationQualifier",
        "path" : "BodyStructure.locationQualifier",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/base/ValueSet/siteQualifier-eu"
        }
      }
    ]
  }
}

```
