# Patient (EU core) - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient (EU core)**

## Resource Profile: Patient (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core | *Version*:0.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PatientEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the Patient resource common to most of the use cases. When the ips-pat-1 invariant is satisfied (Patient.name.given, Patient.name.family or Patient.name.text SHALL be present) then this profile complies with the IPS patient profile. 

**Usages:**

* Examples for this Profile: [Patient/patient-eu-core-example](Patient-patient-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/patient-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-eu-core.csv), [Excel](StructureDefinition-patient-eu-core.xlsx), [Schematron](StructureDefinition-patient-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
  "version" : "0.1.0",
  "name" : "PatientEuCore",
  "title" : "Patient (EU core)",
  "status" : "active",
  "date" : "2025-10-26T21:01:28+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases.\nWhen the ips-pat-1 invariant is satisfied \\(Patient.name.given, Patient.name.family or Patient.name.text SHALL be present\\) then this profile complies with the IPS patient profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "eu-pat-1",
            "severity" : "error",
            "human" : "given, family, text or a data-absent-reason extension SHALL be present",
            "expression" : "family.exists() or given.exists() or text.exists() or extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
          }
        ]
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1
      }
    ]
  }
}

```
