# BodyStructure Example - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BodyStructure Example**

## Example BodyStructure: BodyStructure Example

Profile: [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md)

**Extension Definition for BodyStructure.includedStructure.laterality for Version 5.0**: Left

**morphology**: Blister

**location**: Wrist

**locationQualifier**: Below

**patient**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)



## Resource Content

```json
{
  "resourceType" : "BodyStructure",
  "id" : "example-body-structure-eu",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/bodyStructure-eu-core"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-BodyStructure.includedStructure.laterality",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "7771000",
            "display" : "Left"
          }
        ]
      }
    }
  ],
  "morphology" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "339008",
        "display" : "Blister"
      }
    ]
  },
  "location" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "8205005",
        "display" : "Wrist"
      }
    ]
  },
  "locationQualifier" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "351726001",
          "display" : "Below"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/patient-eu-core-example"
  }
}

```
