# Patient Example - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Example**

## Example Patient: Patient Example

Profile: [Patient (EU core)](StructureDefinition-patient-eu-core.md)

John Doe Male, DoB: 1980-01-01

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 555-1234(Home)
* 123 Example Street Example City EX 12345 EX 
 |
| Links: | * Managing Organization: [Organization Example Health Organization](Organization-organization-eu-core-example.md)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "patient-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
    ]
  },
  "name" : [
    {
      "family" : "Doe",
      "given" : ["John"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-1234",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "birthDate" : "1980-01-01",
  "address" : [
    {
      "line" : ["123 Example Street"],
      "city" : "Example City",
      "state" : "EX",
      "postalCode" : "12345",
      "country" : "EX"
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/organization-eu-core-example"
  }
}

```
