# Artifacts Summary - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### HL7 Europe Base Profiles 

Base profiles for the European context.

| | |
| :--- | :--- |
| [Organization (EU base)](StructureDefinition-organization-eu.md) | This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context. |
| [Patient (EU base)](StructureDefinition-patient-eu.md) | This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context. |
| [Practitioner (EU base)](StructureDefinition-practitioner-eu.md) | This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context. |
| [PractitionerRole (EU base)](StructureDefinition-practitionerRole-eu.md) | This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context. |

### HL7 Europe Core Profiles 

Core profiles for the European context.

| | |
| :--- | :--- |
| [BodyStructure (EU core)](StructureDefinition-bodyStructure-eu-core.md) | This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context. |
| [Location (EU core)](StructureDefinition-location-eu-core.md) | This profile sets minimum expectations for the Location resource to be used for the purpose of this guide. |
| [Organization (EU core)](StructureDefinition-organization-eu-core.md) | This profile sets minimum expectations for the Organization resource common to most of the use cases. |
| [Patient (EU core)](StructureDefinition-patient-eu-core.md) | This profile sets minimum expectations for the Patient resource common to most of the use cases. When the ips-pat-1 invariant is satisfied (Patient.name.given, Patient.name.family or Patient.name.text SHALL be present) then this profile complies with the IPS patient profile. |
| [Patient: Animal (EU core)](StructureDefinition-patient-animal-eu-core.md) | This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide. This is used to identify the species when a specimen is collected from an animal |
| [Practitioner (EU core)](StructureDefinition-practitioner-eu-core.md) | This profile sets minimum expectations for the Practitioner resource common to most of the use cases. |
| [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md) | This profile sets minimum expectations for the PractitionerRole resource common to most of the use cases. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address (EU)](StructureDefinition-Address-eu.md) | This profile extends the Address data type for supporting streetname, housenumber and postal box. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Body Structure Laterality](ValueSet-siteLaterality-eu.md) | Body Structure site laterality qualifier. It indicates - for example - the body site laterality from which a laboratory specimen is collected. (based on SNOMED CT) |
| [Body Structure Qualifier](ValueSet-siteQualifier-eu.md) | Body Structure site qualifier. It indicates - for example - the body site qualifier from which a laboratory specimen is collected. (based on SNOMED CT) |
| [Types of species](ValueSet-speciesType-eu.md) | Animal species types for non-human subjects |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Animal Patient Example](Patient-Patient-animal-example.md) | Example of a Patient resource conforming to the Patient Animal (EU Core) profile. |
| [BodyStructure Example](BodyStructure-example-body-structure-eu.md) | Example of a BodyStructure resource conforming to the BodyStructure (EU) profile. |
| [Location Example](Location-example-location.md) | Example of a Location resource conforming to the Location (EU) profile. |
| [Organization Example](Organization-organization-eu-core-example.md) | Example of an Organization resource conforming to the Organization (EU Core) profile. |
| [Patient Example](Patient-patient-eu-core-example.md) | Example of a Patient resource conforming to the Patient (EU Core) profile. |
| [Practitioner Example](Practitioner-practitioner-eu-core-example.md) | Example of a Practitioner resource conforming to the Practitioner (EU Core) profile. |
| [PractitionerRole Example](PractitionerRole-practitionerRole-eu-core-example.md) | Example of a PractitionerRole resource conforming to the PractitionerRole (EU Core) profile. |

