# Model Map - HL7 Europe Base and Core FHIR IG v0.1.0

* [**Table of Contents**](toc.md)
* **Model Map**

## Model Map

# Model Map

**Maps:**
[EHDSHumanName](#EHDSHumanName)
[EHDSLocation](#EHDSLocation)
[EHDSOrganisation](#EHDSOrganisation)
[EHDSPatient](#EHDSPatient)
[EHDSPatientAnimal](#EHDSPatientAnimal)
[EHDSTelecom](#EHDSTelecom)
[EHDSAddress](#EHDSAddress)
[EHDSHealthProfessional](#EHDSHealthProfessional)
[EHDSBodyStructure](#EHDSBodyStructure)

### EHDSHumanName

[**EHDSHumanName**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSHumanName) to [**HumanName**](https://hl7.org/fhir/datatypes.html#HumanName) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| use | Use | equal | use | Name Use |  |
| text | Text | equal | text | Text representation of the full name |  |
| family | Family | equal | family | Family name (often called 'Surname') |  |
| given | Given | equal | given | Given names (not always 'first'). Includes middle names |  |
| prefix | Prefix | equal | prefix | Parts that come before the name |  |
| suffix | Suffix | equal | suffix | Parts that come after the name |  |

### EHDSLocation

 [**EHDSLocation**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSLocation) to [**LocationEuCore**](StructureDefinition-location-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| identifier | Identifier | equal | identifier | Unique code or number identifying the location to its users |  |
| name | Name | equal | name | Location name |  |
| description | Description | equal | telecom | Location telecom |  |
| type | Type | equal | physicalType | Location type |  |
| address | Address | equal | address | Physical location |  |
| managingOrganisation | Managing organisation | equal | managingOrganization | Managing organization |  |
| partOf | Part of | equal | partOf | Another Location this one is physically a part of |  |

### EHDSOrganisation

 [**EHDSOrganisation**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSOrganisation) to [**OrganizationEuCore**](StructureDefinition-organization-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| identifier | Identifier | equal | identifier | Identifies this organization across multiple systems |  |
| type | Type | equal | type | Organization type |  |
| name | Name | equal | name | Name of the organization |  |
| address | Address | equal | address | An address for the organization |  |
| telecom | Telecom | equal | telecom | Organization telecom |  |
| partOf | Part of | equal | partOf | The organization of which this organization is part of: e.g. an ERN |  |

### EHDSPatient

 [**EHDSPatient**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSPatient) to [**PatientEuCore**](StructureDefinition-patient-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| personalIdentifier | An identifier of the patient that is unique within a defined scope (typically a national patient identifier, but it can also be a temporary identifier issued by the EHR). | equal | identifier | Patient identifiers |  |
| name | Name associated with the patient/subject. | equal | name | A name associated with the patient |  |
| dateOfBirth | Date of birth | equal | birthDate | The date of birth for the patient |  |
| administrativeGender | Administrative gender | equal | gender | Administrative Gender |  |
| address | Mailing and home or office addresses. | equal | address | An address for the individual |  |
| telecom | Telecommunication contact information (addresses) associated to a person. | equal | telecom | A contact detail for the patient |  |
| maritalStatus | Marital (civil) status of a patient | equal | maritalStatus | Marital (civil) status of a patient |  |
| communicationLanguage | The language which can be used to communicate with the patient about his or her health. | equal | communication.language | Communication language |  |

### EHDSPatientAnimal

 [**EHDSPatientAnimal**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSPatientAnimal) to [**PatientAnimalEuCore**](StructureDefinition-patient-animal-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| animalIdentifier | Animal identifier | equal | identifier | An identifier for this patient |  |
| species | Species | equal | extension:patient-animal.extension:species | The animal species. E.g. Dog, Cow. |  |
| breed | Breed | equal | extension:patient-animal.extension:breed | The breed of an animal. |  |
| genderStatus | Gender status | equal | extension:patient-animal.extension:genderStatus | The state of the animal's reproductive organs. |  |
| name | Name | equal | name | A name associated with the patient |  |
| dateOfBirth | Date of birth | equal | birthDate | The date of birth for the patient |  |
| gender | Gender | relatedto | gender | A recorded sex or gender property for the individual |  |
| address | Address | equal | address | An address for the individual |  |
| deceased[x] | Deceased | equal | deceased[x] | Indicates if the individual is deceased or not |  |

### EHDSTelecom

 [**EHDSTelecom**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSTelecom) to [**ContactPoint**](https://hl7.org/fhir/datatypes.html#ContactPoint) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| use | Use | equal | use | Purpose of this contact point |  |
| type | Type | equal | system | Telecommunications form for contact point |  |
| value | Value | equal | value | The actual contact point details |  |

### EHDSAddress

 [**EHDSAddress**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSAddress) to [**AddressEu**](StructureDefinition-Address-eu.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| use | Purpose of the address | equal | use | purpose of this address |  |
| type | Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both. | equal | type | The type of an address (physical / postal). |  |
| text | Text representation of the address | equal | text | Text representation of the address |  |
| street | Name of the street | equal | line.extension:streetName | streetName |  |
| houseNumber | House number | equal | line.extension:houseNumber | houseNumber |  |
| postBox | Post box | equal | line.extension:postBox | postBox |  |
| city | City | equal | city | Name of city, town etc. |  |
| postalCode | Postal code | equal | postalCode | Postal code for area |  |
| country | Country name and country code | equivalent | country | Country | for the country name |
| "" | Country name and country code | equivalent | extension:countryCode | code for string | for the country name |

### EHDSHealthProfessional

#### PractitionerRoleEuCore

 [**EHDSHealthProfessional**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSHealthProfessional) to [**PractitionerRoleEuCore**](StructureDefinition-practitionerRole-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| identifier | An identifier of the health professional that is unique within a defined scope. Example: National health professional ID. Multiple identifiers could be provided. | narrower | identifier | Business identifier | The mapping depends on the type of identifier |
| name | Name of the health professional that has been treating or taking responsibility for the patient. | relatedto | practitioner | Practitioner that is able to provide the defined services for the organization |  |
| address | Mailing and office or home addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose. | relatedto | practitioner | Practitioner that is able to provide the defined services for the organization | The mapping depends on the type of address |
| "" | Mailing and office or home addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose. | relatedto | location | The location(s) at which this practitioner provides care | The mapping depends on the type of address |
| telecom | Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided. | relatedto | telecom | Contact details that are specific to the role/location/service |  |
| professionalRole | Professional role that the health professional is practicing at a given organisation. This is a generalisation of the FHIR PractitionerRole resource, which is used to represent the role of a practitioner in a specific context, such as a specific organisation or location. | relatedto | . |  |  |
| professionalRole.role | Health professional role. Multiple roles could be provided. | equal | code | Roles which this practitioner may perform |  |
| professionalRole.organisation | The organisation where this role is available | equal | organisation | The organisation where this role is available |  |
| professionalRole.specialty | The specialty of a practitioner that describes the functional role they are practicing at a given organisation | equal | specialty | Specific specialty of the practitioner |  |
|  |  |  |  |  |  |

#### PractitionerRoleEuCore

 [**EHDSHealthProfessional**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSHealthProfessional) to [**PractitionerEuCore**](StructureDefinition-practitioner-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| identifier | An identifier of the health professional that is unique within a defined scope. Example: National health professional ID. Multiple identifiers could be provided. | narrower | identifier | Practitioner identifier | The mapping depends on the type of identifier |
| name | Name of the health professional that has been treating or taking responsibility for the patient. | equal | name | Practitioner Name |  |
| address | Mailing and office or home addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose. | narrower | address | Address(es) of the practitioner that are not role specific (typically home address) | The mapping depends on the type of address |
| telecom | Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided. | narrower | telecom | A contact detail for the practitioner (that apply to all roles) | The mapping depends on the type of telecom |
| professionalRole | Professional role that the health professional is practicing at a given organisation. This is a generalisation of the FHIR PractitionerRole resource, which is used to represent the role of a practitioner in a specific context, such as a specific organisation or location. | unmatched |  |  |  |
| professionalRole.role | Health professional role. Multiple roles could be provided. | unmatched |  |  |  |
| professionalRole.organisation | The organisation where this role is available | unmatched |  |  |  |
| professionalRole.specialty | The specialty of a practitioner that describes the functional role they are practicing at a given organisation | unmatched |  |  |  |

### EHDSBodyStructure

 [**EHDSBodyStructure**](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSBodyStructure) to [**BodyStructureEuCore**](StructureDefinition-bodyStructure-eu-core.md) Model Map

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relationship | Element | Description | Notes |
| identifier | Identifier for this instance of the anatomical structure. | equal | identifier | Bodystructure identifier |  |
| morphology | The kind of structure being represented by the body structure at BodyStructure.location. This can define both normal and abnormal morphologies. | equal | morphology | Kind of Structure |  |
| location | Body site | equal | location | Body site |  |
| locationQualifier | Additional qualifier of the body structure (e.g. upper, lower, left side). | equal | locationQualifier | Body site modifier |  |
| laterality | Body structure laterality (e.g. left, right) | equal | extension[laterality] | Body Structure Laterality |  |
| description | Textual description of the body structure | equal | text | Text summary of the resource, for human interpretation |  |

