# Immunization Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Example**

## Example Immunization: Immunization Example

Profile: [Immunization (EU core)](StructureDefinition-immunization-eu-core.md)

**status**: Completed

**vaccineCode**: SARS-CoV-2 mRNA vaccine

**patient**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)

**occurrence**: 2024-10-05

**primarySource**: true

**location**: [Location Best Location](Location-example-location.md)

**manufacturer**: Example Vaccine Manufacturer

**lotNumber**: CVD2024B04

**site**: Left upper arm structure

**route**: Intramuscular route

### Performers

| | | |
| :--- | :--- | :--- |
| - | **Function** | **Actor** |
| * | Administering Provider | [PractitionerRole General practice (specialty)](PractitionerRole-practitionerRole-eu-core-example.md) |

**reasonCode**: Disease caused by severe acute respiratory syndrome coronavirus 2 (disorder)

### ProtocolApplieds

| | | | |
| :--- | :--- | :--- | :--- |
| - | **TargetDisease** | **DoseNumber[x]** | **SeriesDoses[x]** |
| * | COVID-19 | 2 | 2 |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "immunization-eu-core-example",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core"
    ]
  },
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1119349007",
        "display" : "SARS-CoV-2 mRNA vaccine"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/patient-eu-core-example"
  },
  "occurrenceDateTime" : "2024-10-05",
  "primarySource" : true,
  "location" : {
    "reference" : "Location/example-location"
  },
  "manufacturer" : {
    "display" : "Example Vaccine Manufacturer"
  },
  "lotNumber" : "CVD2024B04",
  "site" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "368208006",
        "display" : "Left upper arm structure"
      }
    ]
  },
  "route" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "78421000",
        "display" : "Intramuscular route"
      }
    ]
  },
  "performer" : [
    {
      "function" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
            "code" : "AP",
            "display" : "Administering Provider"
          }
        ]
      },
      "actor" : {
        "reference" : "PractitionerRole/practitionerRole-eu-core-example"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "840539006",
          "display" : "Disease caused by severe acute respiratory syndrome coronavirus 2 (disorder)"
        }
      ]
    }
  ],
  "protocolApplied" : [
    {
      "targetDisease" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "840539006",
              "display" : "COVID-19"
            }
          ]
        }
      ],
      "doseNumberPositiveInt" : 2,
      "seriesDosesPositiveInt" : 2
    }
  ]
}

```
