# ServiceRequest Example - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest Example**

## Example ServiceRequest: ServiceRequest Example

**identifier**: `http://example.org/lis-order`/123456

**requisition**: `http://example.org/gp-order`/0901001234567234

**status**: Active

**intent**: Order

**category**: Laboratory procedure

**priority**: ASAP

**code**: Microalbumin Massa/Volume in Urine

**subject**: [John Doe Male, DoB: 1980-01-01](Patient-patient-eu-core-example.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1",
  "identifier" : [
    {
      "system" : "http://example.org/lis-order",
      "value" : "123456"
    }
  ],
  "requisition" : {
    "system" : "http://example.org/gp-order",
    "value" : "0901001234567234"
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "asap",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "14957-5",
        "display" : "Microalbumin [Mass/volume] in Urine"
      }
    ],
    "text" : "Microalbumin Massa/Volume in Urine"
  },
  "subject" : {
    "reference" : "Patient/patient-eu-core-example"
  }
}

```
