# PractitionerRole (EU base) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole (EU base)**

## Resource Profile: PractitionerRole (EU base) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PractitionerRoleEu |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context. 

**Usages:**

* Derived from this Profile: [PractitionerRole (EU core)](StructureDefinition-practitionerRole-eu-core.md)
* Refer to this Profile: [Condition (EU core)](StructureDefinition-condition-eu-core.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/practitionerRole-eu)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitionerRole-eu.csv), [Excel](StructureDefinition-practitionerRole-eu.xlsx), [Schematron](StructureDefinition-practitionerRole-eu.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitionerRole-eu",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu",
  "version" : "2.0.0-ballot",
  "name" : "PractitionerRoleEu",
  "title" : "PractitionerRole (EU base)",
  "status" : "active",
  "date" : "2025-12-19T18:28:31+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "short" : "Business identifier"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "The practitioner providing services for the organization"
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "The organization where the practitioner performs the role"
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "short" : "Roles which this practitioner may perform."
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "short" : "Specialty of the practitioner"
      },
      {
        "id" : "PractitionerRole.telecom",
        "path" : "PractitionerRole.telecom",
        "short" : "Contact details that are specific to the role, location, or service"
      }
    ]
  }
}

```
