# Home - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base | *Version*:2.0.0-ballot |
| Active as of 2025-12-19 | *Computable Name*:Hl7EuBaseIg |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | |

**Acknowledgment**

The development of this Implementation Guide version has been supported by the
**Xt-EHR Joint Action**. Xt-EHR provided expertise, alignment with European health policy priorities, and validation of specifications to enable consistency with EHDS requirements.

### Scope

This Implementation Guide (IG) brings together **base** and **core** HL7® FHIR® artifacts designed specifically for the European context.

It provides a foundation for interoperability, ensuring reusability across national projects, European initiatives, and derived HL7 Europe guides.

The guide supports:

* Developers and implementers who need common building blocks.
* Policymakers and program leads who require consistent definitions for EHDS-aligned projects.
* Standards experts who wish to build on a harmonized European foundation.

### Introduction

The HL7 Europe Base and Core Implementation Guide provides a **layered approach to FHIR interoperability** in the European context; and it aims to support a coherent and reusable set of FHIR specifications across Europe.

It includes:

* **Base profiles.** Loosely constrained baseline definitions of common European concepts (e.g., Patient, Practitioner). They provide flexibility and serve as the foundation for Core and derived profiles.
* **Core profiles.** More constrained profiles designed for reuse across most European IGs. They introduce essential constraints, can often be used directly, and pursue alignment with IPS.

See the [**Introduction**page](introduction.md) for detailed explanations of Base and Core profiles, their relationship with Extensions and scoped IGs, and their alignment with EHDS and IPS.

**Fig. 1 - European Base and Core profiles**

### Guide Publication

This guide is published for two HL7 FHIR versions:

* **HL7 FHIR R4 Base IG** (hl7.fhir.eu.base). This Guide.
* **HL7 FHIR R5 Base IG** (hl7.fhir.eu.base-r5). Published at [this link](https://hl7.eu/fhir/base-r5).

Both versions are maintained by HL7 Europe and evolve based on community feedback and EHDS requirements.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.eu.base",
  "url" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
  "version" : "2.0.0-ballot",
  "name" : "Hl7EuBaseIg",
  "title" : "HL7 Europe Base and Core FHIR IG",
  "status" : "active",
  "date" : "2025-12-19T18:28:31+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This guide collects base and core profiles to be used in the European context. It also includes common artifacts, such as the profiles describing the European Health Insurance Card.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "packageId" : "hl7.fhir.eu.base",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "2.0.0"
    },
    {
      "id" : "hl7_fhir_uv_xver_r5_r4",
      "uri" : "http://hl7.org/fhir/5.0/ImplementationGuide/hl7.fhir.uv.xver-r5.r4",
      "packageId" : "hl7.fhir.uv.xver-r5.r4",
      "version" : "0.0.1-snapshot-2"
    },
    {
      "id" : "hl7_fhir_eu_extensions_r4",
      "uri" : "http://hl7.eu/fhir/extensions",
      "packageId" : "hl7.fhir.eu.extensions.r4",
      "version" : "1.2.0"
    },
    {
      "id" : "ihe_pharm_mpd_r4",
      "uri" : "https://profiles.ihe.net/PHARM/MPD",
      "packageId" : "ihe.pharm.mpd.r4",
      "version" : "1.0.0-comment-2"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.eu/CodeSystem/v3-ActCode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "ips-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/base/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.eu/CodeSystem/v3-ActCode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "ips-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/base/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "EuBaseProfiles",
        "name" : "HL7 Europe Base Profiles",
        "description" : "Base profiles for the European context."
      },
      {
        "id" : "EuCoreProfilesSTU1",
        "name" : "HL7 Europe Core Profiles",
        "description" : "Core profiles for the European context."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Address-eu"
        },
        "name" : "Address (EU)",
        "description" : "This profile extends the Address data type for supporting streetname, housenumber and postal box.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/allergyIntolerance-eu-core"
        },
        "name" : "Allergy Intolerance (EU core)",
        "description" : "This profile sets minimum expectations for the AllergyIntolerance resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/allergyintolerance-eu-core-example"
        },
        "name" : "AllergyIntolerance Example",
        "description" : "Example of an AllergyIntolerance resource conforming to the AllergyIntolerance (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/allergyIntolerance-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Patient-animal-example"
        },
        "name" : "Animal Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient Animal (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/patient-animal-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteLaterality-eu"
        },
        "name" : "Body Structure Laterality",
        "description" : "Body Structure site laterality qualifier. It indicates - for example - the body site laterality from which a laboratory specimen is collected. (based on SNOMED CT)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/siteQualifier-eu"
        },
        "name" : "Body Structure Qualifier",
        "description" : "Body Structure site qualifier. It indicates - for example - the body site qualifier from which a laboratory specimen is collected. (based on SNOMED CT)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bodyStructure-eu-core"
        },
        "name" : "BodyStructure (EU core)",
        "description" : "This profile specifies how the HL7 FHIR BodyStructure resource should be used for conveying commonly used concepts in the European context.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BodyStructure"
          }
        ],
        "reference" : {
          "reference" : "BodyStructure/example-body-structure-eu"
        },
        "name" : "BodyStructure Example",
        "description" : "Example of a BodyStructure resource conforming to the BodyStructure (EU) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/bodyStructure-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-eu-core"
        },
        "name" : "Composition (EU core)",
        "description" : "This profile sets minimum expectations for the Composition resource for commonly used EHDS documents.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/26032a57-083a-4ddf-b019-e566ae02f740"
        },
        "name" : "Composition Example",
        "description" : "Example of a Laboratory Report Composition conforming to the Composition (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/composition-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-eu-core"
        },
        "name" : "Condition (EU core)",
        "description" : "This profile sets minimum expectations for the Condition resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/condition-eu-core-example"
        },
        "name" : "Condition Example",
        "description" : "Example of a Condition resource conforming to the Condition (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/condition-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/diagnosticReport-eu-core"
        },
        "name" : "DiagnosticReport (EU core)",
        "description" : "This profile sets minimum expectations for the DiagnosticReport resource for commonly used EHDS documents.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/5679723c-4fae-4ba7-9f09-5438a827bfda"
        },
        "name" : "DiagnosticReport Example",
        "description" : "Example of a Laboratory Report DiagnosticReport conforming to the DiagnosticReport (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/diagnosticReport-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ehdsCategories-eu"
        },
        "name" : "EHDS Categories",
        "description" : "EHDS Categories: it indicates the EHDS category that document belongs to.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/flag-eu-core"
        },
        "name" : "Flag (EU core)",
        "description" : "This profile defines the core constraints and extensions for a Flag resource when used in European systems for communicating warnings, alerts, or reminders about important health information.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Flag"
          }
        ],
        "reference" : {
          "reference" : "Flag/flag-eu-core-example"
        },
        "name" : "Flag Example",
        "description" : "Example of a Flag resource conforming to the Flag (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/flag-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/immunization-eu-core"
        },
        "name" : "Immunization (EU core)",
        "description" : "This profile sets minimum expectations for the Immunization resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/immunization-eu-core-example"
        },
        "name" : "Immunization Example",
        "description" : "Example of an Immunization resource conforming to the Immunization (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/lab-obsCode-eu-lab"
        },
        "name" : "Laboratory Code",
        "description" : "Laboratory observation codes. List of Laboratory observation codes containing LOINC and NPU.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/location-eu-core"
        },
        "name" : "Location (EU core)",
        "description" : "This profile sets minimum expectations for the Location resource to be used for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-location"
        },
        "name" : "Location Example",
        "description" : "Example of a Location resource conforming to the Location (EU) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/location-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicalTestResult-eu-core"
        },
        "name" : "MedicalTestResult (EU core)",
        "description" : "This profile sets minimum expectations for the Observation resource for Medical Test Results common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-eu-core"
        },
        "name" : "Medication (EU core)",
        "description" : "This profile sets minimum expectations for the Medication resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/01A-Cefuroxime1500GenericExplicit"
        },
        "name" : "Medication Example",
        "description" : "Example of a Medication conforming to the Medication (EU Core) profile. It represents  Cefuroxime 1500mg (1.5g) powder for solution in a vial.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/medication-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationIntendedUse-eu"
        },
        "name" : "Medication Intended Use",
        "description" : "Medication intended use: it indicates the intended use of a medication for a patient (based on SNOMED CT).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationRequest-eu-core"
        },
        "name" : "MedicationRequest (EU core)",
        "description" : "This profile sets minimum expectations for the MedicationRequest resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/400C-prescription-cefuroxime-singleline"
        },
        "name" : "MedicationRequest Example",
        "description" : "Example of a MedicationRequest conforming to the MedicationRequest (EU Core) profile. \nIt is a prescription/request with one medication and changing dosaging. Uses 'actionable' tag. Cefuroxime sodium.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/medicationRequest-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationStatement-eu-core"
        },
        "name" : "MedicationStatement (EU core)",
        "description" : "This profile sets minimum expectations for the MedicationStatement resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/example-medicationstatement-eucore"
        },
        "name" : "MedicationStatement Example",
        "description" : "Example of a MedicationStatement conforming to the MedicationStatement (EU Core) profile. It describes a patient taking Enalapril.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/763f7902-8103-4d10-8bd1-546a726d43ee"
        },
        "name" : "Observation Example",
        "description" : "Example of a Laboratory Result Observation conforming to the Medical Test Result (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/medicalTestResult-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu"
        },
        "name" : "Organization (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Organization resource should be used for conveying commonly used concepts in the European context.",
        "exampleBoolean" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-eu-core"
        },
        "name" : "Organization (EU core)",
        "description" : "This profile sets minimum expectations for the Organization resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/organization-eu-core-example"
        },
        "name" : "Organization Example",
        "description" : "Example of an Organization resource conforming to the Organization (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/organization-eu"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu"
        },
        "name" : "Patient (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Patient resource should be used for conveying commonly used concepts in the European context.",
        "exampleBoolean" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-eu-core"
        },
        "name" : "Patient (EU core)",
        "description" : "This profile sets minimum expectations for the Patient resource common to most of the use cases.\nWhen the ips-pat-1 invariant is satisfied \\(Patient.name.given, Patient.name.family or Patient.name.text SHALL be present\\) then this profile complies with the IPS patient profile.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient-eu-core-example"
        },
        "name" : "Patient Example",
        "description" : "Example of a Patient resource conforming to the Patient (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-animal-eu-core"
        },
        "name" : "Patient: Animal (EU core)",
        "description" : "This profile defines how to represent an Animal as subject of care in FHIR for the purpose of this guide.\nThis is used to identify the species when a specimen is collected from an animal",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/periodsOfLife-eu"
        },
        "name" : "Periods of Life",
        "description" : "Periods of life: it indicates the period of life of a patient (based on SNOMED CT).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu"
        },
        "name" : "Practitioner (EU base)",
        "description" : "This profile specifies how the HL7 FHIR Practitioner resource should be used for conveying commonly used concepts in the European context.",
        "exampleBoolean" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-eu-core"
        },
        "name" : "Practitioner (EU core)",
        "description" : "This profile sets minimum expectations for the Practitioner resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner-eu-core-example"
        },
        "name" : "Practitioner Example",
        "description" : "Example of a Practitioner resource conforming to the Practitioner (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu"
        },
        "name" : "PractitionerRole (EU base)",
        "description" : "This profile specifies how the HL7 FHIR PractitionerRole resource should be used for conveying commonly used concepts in the European context.",
        "exampleBoolean" : false,
        "groupingId" : "EuBaseProfiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerRole-eu-core"
        },
        "name" : "PractitionerRole (EU core)",
        "description" : "This profile sets minimum expectations for the PractitionerRole resource common to most of the use cases.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/practitionerRole-eu-core-example"
        },
        "name" : "PractitionerRole Example",
        "description" : "Example of a PractitionerRole resource conforming to the PractitionerRole (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure-eu-core"
        },
        "name" : "Procedure (EU core)",
        "description" : "This profile represents the constraints applied to the Procedure resource by this guide.",
        "exampleBoolean" : false,
        "groupingId" : "EuCoreProfilesSTU1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/procedure-eu-core-example"
        },
        "name" : "Procedure Example",
        "description" : "Example of a Procedure resource conforming to the Procedure (EU Core) profile.",
        "exampleCanonical" : "http://hl7.eu/fhir/base/StructureDefinition/procedure-eu-core"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/1d4cbcd1-e0d3-49b6-92d8-1893da8d08e1"
        },
        "name" : "ServiceRequest Example",
        "description" : "Laboratory Report ServiceRequest resource used by the DiagnosticReport example.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/speciesType-eu"
        },
        "name" : "Types of species",
        "description" : "Animal species types for non-human subjects",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors and Contributors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "crossversionanalysis.html"
            }
          ],
          "nameUrl" : "crossversionanalysis.html",
          "title" : "Cross-version Analysis",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "knownissues.html"
            }
          ],
          "nameUrl" : "knownissues.html",
          "title" : "Known/Open Issues",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "introduction.html"
            }
          ],
          "nameUrl" : "introduction.html",
          "title" : "Introduction",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "modelmap.html"
            }
          ],
          "nameUrl" : "modelmap.html",
          "title" : "Model Map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logicalmodels.html"
            }
          ],
          "nameUrl" : "logicalmodels.html",
          "title" : "Logical Models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "missing-data.html"
            }
          ],
          "nameUrl" : "missing-data.html",
          "title" : "Handling Missing Data",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsaddress.html"
            }
          ],
          "nameUrl" : "map-ehdsaddress.html",
          "title" : "EHDSAddress to FHIR Address Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsbodystructure.html"
            }
          ],
          "nameUrl" : "map-ehdsbodystructure.html",
          "title" : "EHDSBodyStructure to FHIR BodyStructure Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdshealthprofessional.html"
            }
          ],
          "nameUrl" : "map-ehdshealthprofessional.html",
          "title" : "EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsorganisation.html"
            }
          ],
          "nameUrl" : "map-ehdsorganisation.html",
          "title" : "EHDSOrganisation to FHIR Organization Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdslocation.html"
            }
          ],
          "nameUrl" : "map-ehdslocation.html",
          "title" : "EHDSLocation to FHIR Location Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdshumanname.html"
            }
          ],
          "nameUrl" : "map-ehdshumanname.html",
          "title" : "EHDSHumanName to FHIR HumanName Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdspatient.html"
            }
          ],
          "nameUrl" : "map-ehdspatient.html",
          "title" : "EHDSPatient to FHIR Patient Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdspatientanimal.html"
            }
          ],
          "nameUrl" : "map-ehdspatientanimal.html",
          "title" : "EHDSPatientAnimal to FHIR Patient (Animal) Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdstelecom.html"
            }
          ],
          "nameUrl" : "map-ehdstelecom.html",
          "title" : "EHDSTelecom to FHIR ContactPoint Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsalert.html"
            }
          ],
          "nameUrl" : "map-ehdsalert.html",
          "title" : "EHDSAlert to FHIR Flag Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsallergyintolerance.html"
            }
          ],
          "nameUrl" : "map-ehdsallergyintolerance.html",
          "title" : "EHDSAllergyIntolerance to FHIR AllergyIntolerance Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdscondition.html"
            }
          ],
          "nameUrl" : "map-ehdscondition.html",
          "title" : "EHDSCondition to FHIR Condition Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsobservation.html"
            }
          ],
          "nameUrl" : "map-ehdsobservation.html",
          "title" : "EHDSObservation to FHIR Observation Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsprocedure.html"
            }
          ],
          "nameUrl" : "map-ehdsprocedure.html",
          "title" : "EHDSProcedure to FHIR Procedure Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsimmunisation.html"
            }
          ],
          "nameUrl" : "map-ehdsimmunisation.html",
          "title" : "EHDSImmunisation to FHIR Immunization Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsdocument.html"
            }
          ],
          "nameUrl" : "map-ehdsdocument.html",
          "title" : "EHDSDocument to FHIR Composition Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsdocument-report.html"
            }
          ],
          "nameUrl" : "map-ehdsdocument-report.html",
          "title" : "EHDSDocument to FHIR DiagnosticReport Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsmedication.html"
            }
          ],
          "nameUrl" : "map-ehdsmedication.html",
          "title" : "EHDSMedication to FHIR Medication Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsmedicationstatement.html"
            }
          ],
          "nameUrl" : "map-ehdsmedicationstatement.html",
          "title" : "EHDSMedicationStatement to FHIR MedicationStatement Mapping",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "map-ehdsmedicationprescription.html"
            }
          ],
          "nameUrl" : "map-ehdsmedicationprescription.html",
          "title" : "EHDSMedicationprescription to FHIR MedicationRequest Mapping",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent/model-maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
