# EHDSDocument to FHIR DiagnosticReport Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSDocument to FHIR DiagnosticReport Mapping**

## EHDSDocument to FHIR DiagnosticReport Mapping

# EHDSDocument ↔ DiagnosticReport

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSDocument ↔ DiagnosticReport

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR DiagnosticReportEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSDocument](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSDocument.html) 
*  **Target FHIR profile:** [DiagnosticReportEuCore](StructureDefinition-diagnosticReport-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Document header elements. | related-to | DiagnosticReport | . | General metadata. | Dataset-level information across the DiagnosticReport instance.**Category (classCode) is missing ?** |
| header.subject | Patient/subject information. | equivalent | DiagnosticReport | subject | Who or what the report is about. | Reference to Patient. |
| header.identifier | Unique identifier of the document. | equivalent | DiagnosticReport | identifier | Version-independent identifier for the DiagnosticReport | Multiple identifiers allowed; DiagnosticReport R4 allows 0..1, R5 0..*.`setId`in HL7 CDA |
| header.identifier | Unique identifier of the document. | equivalent | Bundle | identifier | Persistent identifier for the bundle | Identifier of a specifc version of this document.`id`in HL7 CDA |
| header.authorship | Resource authoring details. | related-to | DiagnosticReport | . |  | see sub elements |
| header.authorship.author[x] | Author(s) who authored the resource. | no-map | DiagnosticReport |  |  | The report author is captured in the composition. |
| header.authorship.datetime | Date and time of authoring/issuing. | equivalent | DiagnosticReport | issued | DateTime this version was made |  |
| header.lastUpdate | Date/time of last technical update. | equivalent | DiagnosticReport | meta.lastUpdated | System-level modification time. | The map applies only in case it represents when the resource was last updated. It is an Instant (i.e. YYYY-MM-DDThh:mm:ss.sss+zz:zz ) |
| header.status | Status of the resource or document. | equivalent | DiagnosticReport | status | The workflow/clinical status of this report |  |
| header.statusReason[x] | Reason for the current status. | no-map | DiagnosticReport |  |  | No native element |
| header.language | Language of the resource (IETF BCP-47). | equivalent | DiagnosticReport | language | Language of the narrative. |  |
| header.documentType | Type of document (e.g., LOINC 60591-5). | equivalent | DiagnosticReport | code | Kind of report (LOINC preferred). |  |
| header.documentTitle | Human readable document title. | no-map | DiagnosticReport |  |  |  |
| header.period | Time of service being documented. | related-to | DiagnosticReport | effectivePeriod | Clinically relevant time/time-period for report |  |
| header.version | Business version of the document. | no-map | DiagnosticReport |  |  |  |
| header.attestation | Document attestation details. | no-map | DiagnosticReport |  |  |  |
| header.legalAuthentication | Document legal authentication details. | no-map | DiagnosticReport |  |  |  |
| header.eventType | Categorisation of the event covered by the document. | relatedTo | DiagnosticReport | category | Service category | Clarify the scope. If it is a classification of the report it should be category |
| header.serviceSpecialty | Details about where the content was created (clinical specialty). | source-is-narrower-than-target | DiagnosticReport | category | Categorizes the report. | Use category to tag specialty if no dedicated extension/profile element exists.**Is this a metadata information or something that have to be captured in the document ? in this case we can use DiagnosticReport.category** |
| header.custodian | Organisation maintaining the document/report. | no-map | DiagnosticReport |  |  |  |
| header.confidentiality | Level of confidentiality (implicit normal). | no-map | DiagnosticReport |  |  |  |
| presentedForm | Narrative easy-to-read representation (e.g., PDF). | equivalent | DiagnosticReport | presentedForm | Entire report as issued | To be determined |

 Return to overview: [EHDS Logical Models ↔ FHIR Profiles](modelmap.md) 

