# EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping**

## EHDSHealthProfessional to FHIR PractitionerRole, Practitioner Mapping

# EHDSHealthProfessional → PractitionerRole, Practitioner

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSHealthProfessional → PractitionerRole, Practitioner

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR PractitionerRole and Practitioner profiles used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSHealthProfessional](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSHealthProfessional) 
*  **Target FHIR profiles:** [PractitionerRole](StructureDefinition-practitionerRole-eu-core.md), [Practitioner](StructureDefinition-practitioner-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| identifier | Identifier of the health professional (e.g. national professional ID). | narrower | PractitionerRole | identifier | Business identifier. | Mapping depends on identifier type. |
| identifier | Identifier of the health professional (e.g. national professional ID). | narrower | Practitioner | identifier | Practitioner identifier. | Mapping depends on identifier type. |
| name | Name of the health professional responsible for the patient. | related-to | PractitionerRole | practitioner | Practitioner that can provide the defined services for the organization. | Name carried on referenced Practitioner. |
| name | Name of the health professional. | equivalent | Practitioner | name | Practitioner name. |  |
| address | Addresses (office / practice / service location). | related-to | PractitionerRole | practitioner / location | Practitioner info and the location(s) at which this practitioner provides care. | Depends on address type (personal vs practice vs service site). |
| address | Addresses of the practitioner that are not role specific (often home). | narrower | Practitioner | address | Address(es) of the practitioner that are not role-specific. | Depends on address type. |
| telecom | Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided. | source-is-broader-than-target | PractitionerRole | telecom〔R4〕 | Contact details specific to this role/location/service. | R4 commonly telecom; R5 may surface contact.telecom. |
| telecom | Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided. | source-is-broader-than-target | PractitionerRole | contact.telecom〔R5〕 | Contact details specific to this role/location/service. | R4 commonly telecom; R5 may surface contact.telecom. |
| telecom | Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided. | source-is-broader-than-target | Practitioner | telecom | Contact detail for the practitioner (applies to all roles). | Depends on telecom type. |
| professionalRole | Role practiced at an organisation (generalised PractitionerRole). | related-to | PractitionerRole | . | Role context, including organisation and specialty. | Maps across multiple PractitionerRole elements. |
| professionalRole.role | Health professional role(s). | equivalent | PractitionerRole | code | Roles this practitioner may perform. | May repeat. |
| professionalRole.organisation | Organisation where this role is available. | equivalent | PractitionerRole | organization | The organisation where this role is available. |  |
| professionalRole.specialty | Specialty practiced in that organisation. | equivalent | PractitionerRole | specialty | Specific specialty of the practitioner. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

