# EHDSObservation to FHIR Observation Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSObservation to FHIR Observation Mapping**

## EHDSObservation to FHIR Observation Mapping

# EHDSObservation → Observation

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSObservation → Observation

 This page explains how conceptual elements from the EHDS Observation logical model for medical test results are expressed in the corresponding FHIR Observation profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSObservation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSObservation.html) 
*  **Target FHIR profile:** [Observation](StructureDefinition-medicalTestResult-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | Observation | . | General metadata. | Dataset-level; not usually carried in Observation as-is. |
| header.subject | Patient who is receiving health care. | equivalent | Observation | subject | Who/what the observation is about. | Reference to Patient (or other allowed subject types). |
| header.identifier | Business identifier for the object. | equivalent | Observation | identifier | Business identifier for this observation. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details. | no-map | Observation |  | . | Observation lacks a dedicated recorder. Only when the observation result was issued can be represented. |
| header.authorship.author[x] | Author(s) who issued the resource. | no-map | Observation |  |  | Observation lacks a dedicated recorder. |
| header.authorship.datetime | Date and time of authoring/issuing. | equivalent | Observation | issued | When the observation result was issued. | 1.. in the model 0.. in the profile. |
| header.lastUpdate | Last technical correction/update. | source-is-broader-than-target | Observation | meta.lastUpdated | When the resource version last changed. | Use only when the timestamp reflects resource update (instant). |
| header.status | Status of the resource. | equivalent | Observation | status | Registered | preliminary | final | amended | ... | EHDS uses CodeableConcept; Observation.status is a required code. Align to HL7 ObservationStatus. |
| header.statusReason[x] | Reason for the current status. | no-map | Observation | - |  | No core element; use an extension if the status rationale is required. |
| header.language | Language in which the resource is written. | equivalent | Observation | language | Language of the resource. |  |
| directSubject[x] | The direct subject of the observation if different from the patient. | equivalent | Observation | focus | Focus of the observation when not the primary subject. |  |
| observationDate[x] | Clinically relevant time or period for the observation. | equivalent | Observation | effective[x] | Clinically relevant time or time-period. | 1.. in the model 0.. in the profile. Map to`effectiveDateTime`or`effectivePeriod`. |
| code | Observation code. | equivalent | Observation | code | What is being observed. |  |
| originalName | Original (conventional) name of the observation. | equivalent | Observation | code.text | Text representation of the observation code. |  |
| method | Observation method. | equivalent | Observation | method | How it was done. |  |
| order | Order this observation belongs to. | equivalent | Observation | basedOn | Plan or request fulfilled by this observation. |  |
| performer[x] | Performer of the observation. | equivalent | Observation | performer | Who performed or produced the observation. | Supports Practitioner, PractitionerRole, Patient, RelatedPerson. |
| anatomicLocation | Anatomic location and laterality. | source-is-broader-than-target | Observation | bodySite | Observed body site. |  |
| anatomicLocation | Anatomic location and laterality. | source-is-broader-than-target | Observation | extension[bodyStructure]〔R4〕 | Observed body structure |  |
| anatomicLocation | Anatomic location and laterality. | equivalent | Observation | bodyStructure〔R5〕 | Observed body structure |  |
| result | Result of the observation. | related-to | Observation | . |  |  |
| result.value[x] | Observation result value. | equivalent | Observation | value[x] | Result value. | 1.. in the model 0.. in the profile. Use the matching datatype (string, Quantity, Range, CodeableConcept). |
| result.uncertainty | Measurement uncertainty type and interval. | equivalent | Quantity | extension[uncertainty] | - | http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty extension for the Quantity data type. |
| dataAbsentReason | Why the expected value is missing. | equivalent | Observation | dataAbsentReason | Reason for missing result. |  |
| referenceRange | Reference range(s) for interpretation. | equivalent | Observation | referenceRange | Guidance for interpretation. |  |
| interpretation | Reference interval and result interpretation. | equivalent | Observation | interpretation | High/low/abnormal, etc. |  |
| resultDescription | Comments and narrative representation. | source-is-broader-than-target | Observation | note | Comment or annotation. |  |
| component | Sub-observations (e.g. panel members). | equivalent | Observation | component | Observation component. |  |
| component.code | Code representing the observation. | equivalent | Observation | component.code | What is being observed. |  |
| component.result | Result of the sub-observation. | related-to | Observation | component | Component result value. |  |
| component.result.value[x] | Component result value. | equivalent | Observation | component.value[x] | Component result value. |  |
| component.result.uncertainty | Measurement uncertainty type and interval. | equivalent | Quantity | extension[uncertainty] | - | http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty extension for the Quantity data type. |
| component.dataAbsentReason | Why the component value is missing. | equivalent | Observation | component.dataAbsentReason | Reason for missing component result. |  |
| component.referenceRange | Reference range for the component. | equivalent | Observation | component.referenceRange | Guidance for interpreting the component value. |  |
| component.interpretation | Component interpretation. | equivalent | Observation | component.interpretation | Interpretation of the component. |  |
| derivedFrom[x] | Related resource from which this observation is derived. | equivalent | Observation | derivedFrom | What the observation is based on. | Supports references to Observation, ImagingStudy, DiagnosticReport, etc. |
| triggeredBy[x] | Observations that triggered this observation. | equivalent | Observation | extension[triggeredBy]〔R4〕 | What initiated this observation. | Standard in R5; use the R5 element or the pre-adopted extension in R4. |
| triggeredBy[x] | Observations that triggered this observation. | equivalent | Observation | triggeredBy〔R5〕 | What initiated this observation. | Standard in R5; use the R5 element or the pre-adopted extension in R4. |
| hasMember[x] | Group observation that includes the target as a member. | equivalent | Observation | hasMember | Related members of a panel or battery. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

