# EHDSOrganisation to FHIR Organization Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSOrganisation to FHIR Organization Mapping**

## EHDSOrganisation to FHIR Organization Mapping

# EHDSOrganisation → Organization

> The content of this page is automatically generated and doesn't document the actual mapping.Please don't use this material for implementation purposes !

**Context**Xt-EHR currently has no dedicated common model for
`MedicationRequest`. For that reason, this mapping is based on the prescription model realised by the HL7 Europe Medication Prescription and Dispense (MPD) FHIR Implementation Guide (
[https://hl7.eu/fhir/mpd](https://hl7.eu/fhir/mpd)).

### EHDSOrganisation → Organization

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR OrganizationEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSOrganisation](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSOrganisation) 
*  **Target FHIR profile:** [OrganizationEuCore](StructureDefinition-organization-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| identifier | Identifier for the organisation. | equivalent | Organization | identifier | Identifies this organization across multiple systems. |  |
| type | Kind of organisation (e.g. hospital, lab, payer). | equivalent | Organization | type | Organization type. |  |
| name | Official or common name of the organisation. | equivalent | Organization | name | Name of the organization. |  |
| address | Postal / visit address for the organisation. | equivalent | Organization | address〔R4〕 | An address for the organization. | In R4 typically address; in R5 often contact.address. |
| address | Postal / visit address for the organisation. | equivalent | Organization | contact.address〔R5〕 | An address for the organization. | In R4 typically address; in R5 often contact.address. |
| telecom | General contact details (phone, fax, email). | equivalent | Organization | telecom〔R4〕 | Organization telecom. | In R4 telecom; in R5 contact.telecom. |
| telecom | General contact details (phone, fax, email). | equivalent | Organization | contact.telecom〔R5〕 | Organization telecom. | In R4 telecom; in R5 contact.telecom. |
| partOf | Owning / parent organisation. | equivalent | Organization | partOf | The organization of which this organization is part. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

