# EHDSPatientAnimal to FHIR Patient (Animal) Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSPatientAnimal to FHIR Patient (Animal) Mapping**

## EHDSPatientAnimal to FHIR Patient (Animal) Mapping

# EHDSPatientAnimal → PatientAnimalEuCore

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSPatientAnimal → PatientAnimalEuCore

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR PatientAnimalEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSPatientAnimal](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSPatientAnimal) 
*  **Target FHIR profile:** [PatientAnimalEuCore](StructureDefinition-patient-animal-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| animalIdentifier | Animal identifier. | equivalent | Patient | identifier | An identifier for this patient. |  |
| species | Animal species. | equivalent | Patient | extension:patient-animal.extension:species | The animal species. |  |
| breed | Breed of the animal. | equivalent | Patient | extension:patient-animal.extension:breed | The breed of an animal. |  |
| genderStatus | Reproductive status. | equivalent | Patient | extension:patient-animal.extension:genderStatus | The state of the animal's reproductive organs. |  |
| name | Name of the animal patient. | equivalent | Patient | name | A name associated with the patient. |  |
| dateOfBirth | Date of birth. | equivalent | Patient | birthDate | The date of birth for the patient. |  |
| gender | Recorded sex / gender property. | related-to | Patient | gender | A recorded sex or gender property for the individual. | May differ from reproductive status. |
| address | Address of the owner / holding location. | equivalent | Patient | address | An address for the individual. |  |
| deceased[x] | Whether the animal is deceased (and when). | equivalent | Patient | deceased[x] | Indicates if the individual is deceased or not. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

