# Model Map - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Model Map**

## Model Map

# EHDS Logical Models to FHIR Profiles Mapping

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

### EHDS Logical Models → FHIR Profiles

 The Xt-EHR Joint Action defines EHDS logical data models for core clinical and administrative concepts. This Implementation Guide provides HL7 FHIR profiles that realise those models. 

 The sections below group the EHDS logical models into categories. 

Each table shows:

* the logical model
* the FHIR datatype or profile(s) used in this IG
* a link to the detailed element-by-element mapping

####  🧩 Foundational Models 

| | | |
| :--- | :--- | :--- |
| [EHDSAddress](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAddress.html) | [`AddressEu`](StructureDefinition-Address-eu.md) | [EHDSAddress Mapping](map-ehdsaddress.md) |
| [EHDSHumanName](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSHumanName.html) | [`HumanName`](https://hl7.org/fhir/datatypes.html#HumanName) | [EHDSHumanName Mapping](map-ehdshumanname.md) |
| [EHDSTelecom](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSTelecom.html) | [`ContactPoint`](https://hl7.org/fhir/datatypes.html#ContactPoint) | [EHDSTelecom Mapping](map-ehdstelecom.md) |
| [EHDSBodyStructure](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSBodyStructure.html) | [`BodyStructureEuCore`](StructureDefinition-bodyStructure-eu-core.md) | [EHDSBodyStructure Mapping](map-ehdsbodystructure.md) |

####  🧑‍⚕️ Entity Models 

| | | |
| :--- | :--- | :--- |
| [EHDSPatient](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSPatient.html) | [`PatientEuCore`](StructureDefinition-patient-eu-core.md) | [EHDSPatient Mapping](map-ehdspatient.md) |
| [EHDSPatientAnimal](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSPatientAnimal.html) | [`PatientAnimalEuCore`](StructureDefinition-patient-animal-eu-core.md) | [EHDSPatientAnimal Mapping](map-ehdspatientanimal.md) |
| [EHDSHealthProfessional](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSHealthProfessional.html) | [`PractitionerRoleEuCore`](StructureDefinition-practitionerRole-eu-core.md),[`PractitionerEuCore`](StructureDefinition-practitioner-eu-core.md) | [EHDSHealthProfessional Mapping](map-ehdshealthprofessional.md) |
| [EHDSOrganisation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSOrganisation.html) | [`OrganizationEuCore`](StructureDefinition-organization-eu-core.md) | [EHDSOrganisation Mapping](map-ehdsorganisation.md) |
| [EHDSLocation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSLocation.html) | [`LocationEuCore`](StructureDefinition-location-eu-core.md) | [EHDSLocation Mapping](map-ehdslocation.md) |

####  🩺 Clinical Information Models 

| | | |
| :--- | :--- | :--- |
| [EHDSAlert](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAlert.html) | [`FlagEuCore`](StructureDefinition-flag-eu-core.md) | [EHDSAlert Mapping](map-ehdsalert.md) |
| [EHDSAllergyIntolerance](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAllergyIntolerance.html) | [`AllergyIntoleranceEuCore`](StructureDefinition-allergyIntolerance-eu-core.md) | [EHDSAllergyIntolerance Mapping](map-ehdsallergyintolerance.md) |
| [EHDSCondition](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSCondition.html) | [`ConditionEuCore`](StructureDefinition-condition-eu-core.md) | [EHDSCondition Mapping](map-ehdscondition.md) |
| [EHDSObservation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSObservation.html) | [`MedicalTestResultEuCore`](StructureDefinition-medicalTestResult-eu-core.md) | [EHDSObservation Mapping](map-ehdsobservation.md) |
| [EHDSProcedure](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSProcedure.html) | [`ProcedureEuCore`](StructureDefinition-procedure-eu-core.md) | [EHDSProcedure Mapping](map-ehdsprocedure.md) |
| [EHDSImmunisation](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSImmunisation.html) | [`ImmunizationEuCore`](StructureDefinition-immunization-eu-core.md) | [EHDSImmunisation Mapping](map-ehdsimmunisation.md) |

####  📄 Document Models 

| | | |
| :--- | :--- | :--- |
| [EHDSDocument](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSDocument.html) | [`CompositionEuCore`](StructureDefinition-composition-eu-core.md) | [EHDSDocument Mapping (Composition)](map-ehdsdocument.md) |
| [EHDSDocument](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSDocument.html) | [`DiagnosticReportEuCore`](StructureDefinition-diagnosticReport-eu-core.md) | [EHDSDocument Mapping (DiagnosticReport)](map-ehdsdocument-report.md) |

####  💊 Medication Models 

| | | |
| :--- | :--- | :--- |
| [EHDSMedication](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSMedication.html) | [`MedicationEuCore`](StructureDefinition-medication-eu-core.md) | [EHDSMedication Mapping](map-ehdsmedication.md) |
| [EHDSMedicationStatement](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSMedicationStatement.html) | [`MedicationStatementEuCore`](StructureDefinition-medicationStatement-eu-core.md) | [EHDSMedicationStatement Mapping](map-ehdsmedicationstatement.md) |
| [EHDSMedicationPrescription](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSMedicationPrescription.html) | [`MedicationRequestEuCore`](StructureDefinition-medicationRequest-eu-core.md) | [EHDSMedicationPrescription Mapping](map-ehdsmedicationprescription.md) |

