# Flag (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Flag (EU core)**

## Resource Profile: Flag (EU core) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/flag-eu-core | *Version*:2.0.0-ballot |
| Active as of 2025-12-19 | *Computable Name*:FlagEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | |

 
This profile defines the core constraints and extensions for a Flag resource when used in European systems for communicating warnings, alerts, or reminders about important health information. 

**Usages:**

* Examples for this Profile: [Flag/flag-eu-core-example](Flag-flag-eu-core-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/flag-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-flag-eu-core.csv), [Excel](StructureDefinition-flag-eu-core.xlsx), [Schematron](StructureDefinition-flag-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "flag-eu-core",
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/flag-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "FlagEuCore",
  "title" : "Flag (EU core)",
  "status" : "active",
  "date" : "2025-12-19T18:28:31+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile defines the core constraints and extensions for a Flag resource when used in European systems for communicating warnings, alerts, or reminders about important health information.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Flag",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Flag",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Flag",
        "path" : "Flag"
      },
      {
        "id" : "Flag.extension",
        "path" : "Flag.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Flag.extension:flagDetailExt",
        "path" : "Flag.extension",
        "sliceName" : "flagDetailExt",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/flag-detail"]
          }
        ]
      },
      {
        "id" : "Flag.extension:flagPriorityExt",
        "path" : "Flag.extension",
        "sliceName" : "flagPriorityExt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/flag-priority"]
          }
        ]
      },
      {
        "id" : "Flag.extension:note",
        "path" : "Flag.extension",
        "sliceName" : "note",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Flag.identifier",
        "path" : "Flag.identifier",
        "short" : "Alert bussiness Identifier"
      },
      {
        "id" : "Flag.status",
        "path" : "Flag.status",
        "short" : "Alert status"
      },
      {
        "id" : "Flag.code",
        "path" : "Flag.code",
        "short" : "Coded or textual message to display to user."
      },
      {
        "id" : "Flag.subject",
        "path" : "Flag.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Flag.period",
        "path" : "Flag.period",
        "short" : "Time period when the alert is active"
      }
    ]
  }
}

```
