# MedicationStatement (EU core) - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatement (EU core)**

## Resource Profile: MedicationStatement (EU core) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core | *Version*:2.0.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MedicationStatementEuCore |
| **Copyright/Legal**: Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0). | | |

 
This profile sets minimum expectations for the MedicationStatement resource common to most of the use cases. This profile is adapted from the MPD work. 

**Usages:**

* Examples for this Profile: [MedicationStatement/example-medicationstatement-eucore](MedicationStatement-example-medicationstatement-eucore.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.base|current/StructureDefinition/medicationStatement-eu-core)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medicationStatement-eu-core.csv), [Excel](StructureDefinition-medicationStatement-eu-core.xlsx), [Schematron](StructureDefinition-medicationStatement-eu-core.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medicationStatement-eu-core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core",
  "version" : "2.0.0-ballot",
  "name" : "MedicationStatementEuCore",
  "title" : "MedicationStatement (EU core)",
  "status" : "active",
  "date" : "2025-12-19T18:28:31+01:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the MedicationStatement resource common to most of the use cases.\nThis profile is adapted from the MPD work.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Copyright HL7 Europe. Licensed under creative commons public domain (CC0 1.0).",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement"
      },
      {
        "id" : "MedicationStatement.extension",
        "path" : "MedicationStatement.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationStatement.extension:adherence",
        "path" : "MedicationStatement.extension",
        "sliceName" : "adherence",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.adherence"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:adherence.extension:code",
        "path" : "MedicationStatement.extension.extension",
        "sliceName" : "code",
        "short" : "Type of adherence."
      },
      {
        "id" : "MedicationStatement.extension:adherence.value[x]",
        "path" : "MedicationStatement.extension.value[x]",
        "max" : "0"
      },
      {
        "id" : "MedicationStatement.identifier",
        "path" : "MedicationStatement.identifier",
        "short" : "Medication Statement Identifier"
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "short" : "State of the medication"
      },
      {
        "id" : "MedicationStatement.statusReason",
        "path" : "MedicationStatement.statusReason",
        "short" : "Reason for the 'exception' statuses of the medication"
      },
      {
        "id" : "MedicationStatement.category",
        "path" : "MedicationStatement.category",
        "short" : "Type of intended use",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "preferred"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.eu/fhir/base/ValueSet/medicationIntendedUse-eu"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "When category is used for describing the intended use of the medication (e.g. Prophylactic use)."
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "A coded concept identifying where the medication included in the MedicationStatement is expected to be consumed or administered.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-statement-category"
        }
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medication-eu-core"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/medication-uv-ips"
        }
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.effective[x]",
        "path" : "MedicationStatement.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationStatement.effective[x]:effectivePeriod",
        "path" : "MedicationStatement.effective[x]",
        "sliceName" : "effectivePeriod",
        "short" : "Period when the medication is/was or should be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "MedicationStatement.informationSource",
        "path" : "MedicationStatement.informationSource",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.reasonCode",
        "path" : "MedicationStatement.reasonCode",
        "short" : "Coded reason for use"
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "short" : "Details of how medication is/was taken or should be taken."
      }
    ]
  }
}

```
