# EHDSAddress to FHIR Address Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSAddress to FHIR Address Mapping**

## EHDSAddress to FHIR Address Mapping

# EHDSAddress → AddressEu

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSAddress → AddressEu

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR AddressEu profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSAddress](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSAddress) 
*  **Target FHIR profile:** [AddressEu](StructureDefinition-Address-eu.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Datatype | Element | Description | Notes |
| use | Purpose of the address. | equivalent | Address | use | Purpose of this address. |  |
| type | Type of address (physical / postal). | equivalent | Address | type | The type of an address (physical / postal). |  |
| text | Text representation of the full address. | equivalent | Address | text | Text representation of the address. |  |
| street | Name of the street. | equivalent | Address | line.extension:streetName | Street name. |  |
| houseNumber | House number. | equivalent | Address | line.extension:houseNumber | House number. |  |
| postBox | Post box. | equivalent | Address | line.extension:postBox | Post box. |  |
| city | City / town name. | equivalent | Address | city | Name of city, town, etc. |  |
| postalCode | Postal code. | equivalent | Address | postalCode | Postal code for area. |  |
| country | Country name and country code | equivalent | Address | country | Country | for the country name |
| "" | Country name and country code | equivalent | Address | extension:countryCode | code for string | for the country name |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

