# EHDSAlert to FHIR Flag Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSAlert to FHIR Flag Mapping**

## EHDSAlert to FHIR Flag Mapping

# EHDSAlert → Flag

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSAlert → Flag

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR FlagEuCore profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSAlert](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSAlert.html) 
*  **Target FHIR profile:** [FlagEuCore](StructureDefinition-flag-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for all patient-related data. | related-to | Flag | . | General metadata. | Dataset-level; not usually carried in Flag as-is. |
| header.subject | Patient/subject this alert is about. | equivalent | Flag | subject | Who/what the flag is about. | Reference to Patient (or other subject). |
| header.identifier | Business identifier for the alert object. | equivalent | Flag | identifier | Business identifier for the flag. | Copy over all identifiers if multiple. |
| header.authorship | Resource authoring details | related-to | Flag | author | Creator of the flag. | Can reference Device, Organization, Patient, Practitioner, or PractitionerRole.1.. in the model 0.. in the profile |
| header.authorship.author[x] | Who created/issued the alert. | equivalent | Flag | author | Creator of the flag. | Can reference Device, Organization, Patient, Practitioner, or PractitionerRole.1.. in the model 0.. in the profile |
| header.authorship.datetime | Date/time the resource was issued. | no map | Flag |  |  |  |
| header.lastUpdate | Last technical correction/update. | related-to | Flag | meta.lastUpdated | When the resource version last changed | The map applies only in case it represents when the resource was last updated. It is an Instant (i.e. YYYY-MM-DDThh:mm:ss.sss+zz:zz ) |
| header.status | Status of the dataset/resource. | no map | Flag |  |  | Suggested to be removed see[Review and Align Use of header.status and header.statusReason[x]](https://github.com/Xt-EHR/xt-ehr-common/issues/363) |
| header.statusReason[x] | Reason for current dataset status. | no map | Flag |  |  | Suggested to be removed see[Review and Align Use of header.status and header.statusReason[x]](https://github.com/Xt-EHR/xt-ehr-common/issues/363) |
| header.language | Language of the resource (IETF tag). | equivalent | Flag | language | Language used in the flag text. |  |
| text | Free text explanation of the alert. | source-is-broader-than-target | Flag | extensions:note.text | Additional notes that apply to this resource or element. | The mapping applies if the text represents additional information collected about the alert.`code.text`can be used for a textual description of the coded alert.`text`for a textual description of the overall alert. |
| priority | Priority of the alert. | equivalent | Flag | extension:flagPriorityExt | A code that identifies the priority of the alert |  |
| status | Status of the alert (active, inactive, entered-in-error…). | equivalent | Flag | status | Indicates if the flag is active, inactive, etc. | Use the EHDS → HL7 Flag-status value set mapping. |
| code | Coded alert/issue being highlighted. | equivalent | Flag | code | Issue being highlighted. | Often SNOMED CT or local code. Should have display. |
| period | Time period when the alert is relevant. | equivalent | Flag | period | Time period when the flag is active. | Map start/end 1:1. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

