# EHDSHumanName to FHIR HumanName Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSHumanName to FHIR HumanName Mapping**

## EHDSHumanName to FHIR HumanName Mapping

# EHDSHumanName → HumanName

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSHumanName → HumanName

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR HumanName datatype used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSHumanName](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSHumanName) 
*  **Target FHIR datatype:** [HumanName](https://hl7.org/fhir/datatypes.html#HumanName) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Datatype | Element | Description | Notes |
| use | Intended use of the name (official, alias, etc.). | equivalent | HumanName | use | Name use code. | e.g. official, usual, nickname. |
| text | Full name as rendered for display. | equivalent | HumanName | text | Text representation of the full name. | Typically a single string. |
| family | Family name / surname. | equivalent | HumanName | family | Family name (often called "surname"). |  |
| given | Given (first / middle) names. | equivalent | HumanName | given | Given names (may include middle names). | Array in FHIR. |
| prefix | Honorifics or titles preceding the name. | equivalent | HumanName | prefix | Parts that come before the name. | e.g. Dr, Prof, Sir. |
| suffix | Post-nominal letters, generational markers, etc. | equivalent | HumanName | suffix | Parts that come after the name. | e.g. Jr, MD, PhD. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

