# EHDSMedicationprescription to FHIR MedicationRequest Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSMedicationprescription to FHIR MedicationRequest Mapping**

## EHDSMedicationprescription to FHIR MedicationRequest Mapping

# EHDSMedicationPrescription → MedicationRequest

**Context**Xt-EHR currently has no dedicated common model for
`MedicationRequest`. For that reason, this mapping is based on the prescription model realised by the HL7 Europe Medication Prescription and Dispense (MPD) FHIR Implementation Guide (
[https://hl7.eu/fhir/mpd](https://hl7.eu/fhir/mpd)).

### EHDSMedicationPrescription → MedicationRequest

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR MedicationRequest profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSMedicationPrescription](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSMedicationPrescription) 
*  **Target FHIR profile:** [MedicationRequest](StructureDefinition-medicationRequest-eu-core.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Common header for the prescription dataset. | related-to | MedicationRequest | . | General metadata. | Dataset-level information; not directly represented on the MedicationRequest instance. |
| header.subject | Patient for whom the medication is prescribed. | equivalent | MedicationRequest | subject | Identifies the patient. | Reference to Patient. |
| header.identifier | Business identifier(s) for the prescription. | source-narrow-than-target | MedicationRequest | identifier | External identifiers for this request. |  |
| header.identifier | Identifier for a single item on the prescription. | source-narrow-than-target | MedicationRequest | groupIdentifier | Identifiers for a group of prescribed items. |  |
| header.authorship | Details about the prescriber (author). | related-to | MedicationRequest | requester | Who is requesting/prescribing the medication. | FHIR separates requester, recorder, and authoredOn; see child elements for specifics. |
| header.authorship.author[x] | The prescriber who made the prescription. | equivalent | MedicationRequest | requester | The authorizing practitioner or organization. | Reference to Practitioner / PractitionerRole / Organization depending on profile rules. |
| header.authorship.datetime | Time of issuing/signing the prescription. | equivalent | MedicationRequest | authoredOn | When the request was authored. |  |
| header.lastUpdate | Last technical correction/update timestamp. | equivalent | MedicationRequest | meta.lastUpdated | System-level modification time. | Populate only if this represents the technical update instant. |
| header.status | Status of authorization to dispense. | equivalent | MedicationRequest | status | Active/on-hold/cancelled/etc. | Use statusReason when additional context is required. |
| header.statusReason[x] | Reason for the current prescription status. | source-is-broader-than-target | MedicationRequest | statusReason | Explains the status. | The model allows for CodeableConcept and string. The target only CodeableConcept. |
| header.language | Language in which the resource is written. | equivalent | MedicationRequest | language | Language of the narrative. |  |
| header.recorder | Recorder of the prescription/draft. | equivalent | MedicationRequest | recorder | Who recorded the request in the system. |  |
| header.recordingDate | Time of authoring the prescription/draft in the system. | related-to | MedicationRequest | eventhistory.recorded | Date recorded in the system. | what is the difference with authorship.datetime? autoredOn ? |
| header.validFrom | Effective date of the prescription. | equivalent | MedicationRequest | dispenseRequest.validityPeriod.start | Start of dispensing validity. |  |
| header.validUntil | Validity period end date. | equivalent | MedicationRequest | dispenseRequest.validityPeriod.end | End of dispensing validity. |  |
| presentedForm | Entire prescription as issued (PDF, etc.). | no-map | MedicationRequest |  |  | Reference a DocumentReference containing the rendered prescription. |
| comment | Additional information or comments. | equivalent | MedicationRequest | note | Textual comments. |  |
| prescriptionItem | Prescription line for a medication. | equivalent | MedicationRequest | . | MedicationRequest instances represent single items. | Create one MedicationRequest per prescription item. |
| prescriptionItem.identifier | Identifier for a single item on the prescription. | equivalent | MedicationRequest | identifier | Identifiers for that single prescribed item. |  |
| prescriptionItem.category | Category or categories of the prescription. | equivalent | MedicationRequest | category | Type of prescription. | Use appropriate value set (reimbursement type, etc.). |
| prescriptionItem.medication | Prescribed product (branded, generic, etc.). | equivalent | MedicationRequest | medication[x]〔R4〕 | Medication as CodeableConcept or Reference. | EHDS model constrains to a reference to EHDSMedication. |
| prescriptionItem.medication | Prescribed product (branded, generic, etc.). | equivalent | MedicationRequest | medication〔R5〕 | Medication as CodeableConcept or Reference. | EHDS model constrains to a reference to EHDSMedication. |
| prescriptionItem.indicationCodeableConcept | Coded reason for the prescription. | equivalent | MedicationRequest | reasonCode〔R4〕 | Why the medication is prescribed. |  |
| prescriptionItem.indicationCodeableConcept | Coded reason for the prescription. | equivalent | MedicationRequest | reason.concept〔R5〕 | Why the medication is prescribed. |  |
| prescriptionItem.indicationEHDSCondition | Diagnosis/reason referenced as a Condition. | equivalent | MedicationRequest | reasonReference〔R4〕 | Reference to the clinical reason. | Reference to Condition or other resource. |
| prescriptionItem.indicationEHDSCondition | Diagnosis/reason referenced as a Condition. | equivalent | MedicationRequest | reason.reference〔R5〕 | Reference to the clinical reason. | Reference to Condition or other resource. |
| prescriptionItem.indicationText | Free-text reason for the prescription. | related-to | MedicationRequest | reasonCode.text | Textual reason. | Alternatively capture as`note`if preferred. |
| prescriptionItem.intendedUseType | Intent of the prescription (prophylaxis, treatment, etc.). | source-is-narrower-than-target | MedicationRequest | category | Classification of the request. | Use dedicated category code or custom extension if additional granularity is required. |
| prescriptionItem.periodOfUse | Overall period over which the medication is to be taken. | related-to | MedicationRequest | extension:effectiveDosePeriod〔R4〕 | Period over which the medication should be taken. |  |
| prescriptionItem.periodOfUse | Overall period over which the medication is to be taken. | related-to | MedicationRequest | effectiveDosePeriod〔R5〕 | Period over which the medication should be taken. |  |
| prescriptionItem.quantityPrescribed | Overall quantity of product prescribed. | equivalent | MedicationRequest | dispenseRequest.extension:prescribedQuantity | Overall amount of product prescribed, independent from the number of repeats. |  |
| prescriptionItem.dosageInstructions | Dosage and administration instructions. | equivalent | MedicationRequest | dosageInstruction | Dosage instructions for administration. | Map each EHDSDosaging entry to a`dosageInstruction`. |
| prescriptionItem.preparationInstructions | Additional instructions about preparation or dispense. | related-to | MedicationRequest | dispenseRequest.extension:dispenserInstruction〔R4〕 | Additional information for the dispenser | FHIR R4 has no dedicated field; preadopt the R5 element or capture as note |
| prescriptionItem.preparationInstructions | Additional instructions about preparation or dispense. | related-to | MedicationRequest | dispenseRequest.dispenserInstruction〔R5〕 | Additional information for the dispenser |  |
| prescriptionItem.substitution.allowedBoolean | Whether substitution is allowed. | equivalent | MedicationRequest | substitution.allowedBoolean | Indicates if substitution is permitted. |  |
| prescriptionItem.substitution.allowedCodeableConcept | How/what substitution is allowed. | source-is-broader-than-target | MedicationRequest | substitution.allowedCodeableConcept〔R5〕 | CodeableConcept describing substitution allowance. | In R4 only boolean exists; use pre-adopted R5 element/extension if needed. |
| prescriptionItem.substitution.reason[x] | Reason for substitution requirements. | equivalent | MedicationRequest | substitution.reason | Why substitution is (not) allowed. | FHIR accepts CodeableConcept; textual reasons may need an additional note. |
| prescriptionItem.status | Status of a single item of the prescription. | equivalent | MedicationRequest | status | Status at the line level. | For single-item prescriptions, same meaning as header.status. |
| prescriptionItem.statusReason[x] | Reason for the line-item status. | equivalent | MedicationRequest | statusReason | Status explanation. | As above, textual-only reasons may require notes. |
| prescriptionItem.repeatsAllowed | Number of refills authorized. | equivalent | MedicationRequest | dispenseRequest.numberOfRepeatsAllowed | Repeat count. |  |
| prescriptionItem.minimumDispenseInterval | Minimum interval between dispenses. | equivalent | MedicationRequest | dispenseRequest.dispenseInterval | Minimum dispense interval. |  |
| prescriptionItem.offLabel.isOffLabelUse | Indicates off-label use. | related-to | MedicationRequest | extension:offLabelUse | Flag for off-label prescription. | Implementer-specific extension required. |
| prescriptionItem.offLabel.reason[x] | Reason for off-label use. | related-to | MedicationRequest | extension:offLabelUse.reason | Explanation of off-label decision. | Same extension as above; allow CodeableConcept or string. |
| prescriptionItem.comment | Additional information or comments (line-level). | equivalent | MedicationRequest | note.text | Line-level comments. | Use`note.author`/`note.time`if available. |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

