# EHDSTelecom to FHIR ContactPoint Mapping - HL7 Europe Base and Core FHIR IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **EHDSTelecom to FHIR ContactPoint Mapping**

## EHDSTelecom to FHIR ContactPoint Mapping

# EHDSTelecom → ContactPoint

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

**Yellow row/cells:**In this ballot publication, some row/cells of the mapping table have been left in yellow to indicate areas requiring further review or refinement; including feedback from the Xt-EHR joint action (see note above). These highlights will be addressed in subsequent updates to ensure accuracy and completeness of the mappings.

### EHDSTelecom → ContactPoint

 This page explains how conceptual elements from the EHDS logical model are expressed in the corresponding FHIR ContactPoint datatype used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSTelecom](https://www.xt-ehr.eu/fhir/models/StructureDefinition/EHDSTelecom) 
*  **Target FHIR datatype:** [ContactPoint](https://hl7.org/fhir/datatypes.html#ContactPoint) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Datatype | Element | Description | Notes |
| use | Intended use (home, work, temp, etc.). | equivalent | ContactPoint | use | Purpose of this contact point. |  |
| type | Type of channel (phone, email, etc.). | equivalent | ContactPoint | system | Telecommunications form for contact point. |  |
| value | Actual contact detail string. | equivalent | ContactPoint | value | The actual contact point details. |  |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

