# Condition: example with extensions - HL7 Europe Extensions v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition: example with extensions**

## Example Condition: Condition: example with extensions

**clinicalStatus**: Active

**code**: Chronic kidney disease stage 1

**subject**: Nice Patient

**onset**: 40 a(Details: UCUM codea = 'a')



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-example",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "431855005",
        "display" : "Chronic kidney disease stage 1"
      }
    ]
  },
  "subject" : {
    "display" : "Nice Patient"
  },
  "onsetAge" : {
    "extension" : [
      {
        "url" : "http://hl7.eu/fhir/extensions/StructureDefinition/periods-of-life",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "41847000",
              "display" : "Adulthood"
            }
          ]
        }
      }
    ],
    "value" : 40,
    "system" : "http://unitsofmeasure.org",
    "code" : "a"
  }
}

```
